/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.DisplayString;
import org.opendaylight.yang.gen.v1.http.netconfcentral.org.ns.toaster.rev091120.ToasterData;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

public interface Toaster
extends ChildOf<ToasterData>,
Augmentable<Toaster> {
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("toaster");

    default public Class<Toaster> implementedInterface() {
        return Toaster.class;
    }

    public static int bindingHashCode(@NonNull Toaster obj) {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(obj.getDarknessFactor());
        result = 31 * result + Objects.hashCode(obj.getToasterManufacturer());
        result = 31 * result + Objects.hashCode(obj.getToasterModelNumber());
        result = 31 * result + Objects.hashCode((Object)obj.getToasterStatus());
        result = 31 * result + obj.augmentations().hashCode();
        return result;
    }

    public static boolean bindingEquals(@NonNull Toaster thisObj, Object obj) {
        if (thisObj == obj) {
            return true;
        }
        Toaster other = (Toaster)CodeHelpers.checkCast(Toaster.class, (Object)obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getDarknessFactor(), other.getDarknessFactor())) {
            return false;
        }
        if (!Objects.equals(thisObj.getToasterManufacturer(), other.getToasterManufacturer())) {
            return false;
        }
        if (!Objects.equals(thisObj.getToasterModelNumber(), other.getToasterModelNumber())) {
            return false;
        }
        if (!Objects.equals((Object)thisObj.getToasterStatus(), (Object)other.getToasterStatus())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }

    public static String bindingToString(@NonNull Toaster obj) {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"Toaster");
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"darknessFactor", (Object)obj.getDarknessFactor());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"toasterManufacturer", (Object)obj.getToasterManufacturer());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"toasterModelNumber", (Object)obj.getToasterModelNumber());
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"toasterStatus", (Object)((Object)obj.getToasterStatus()));
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", obj.augmentations().values());
        return helper.toString();
    }

    public DisplayString getToasterManufacturer();

    public DisplayString getToasterModelNumber();

    public ToasterStatus getToasterStatus();

    public Uint32 getDarknessFactor();

    public static enum ToasterStatus implements Enumeration
    {
        Up(1, "up"),
        Down(2, "down");

        private static final Map<String, ToasterStatus> NAME_MAP;
        private static final Map<Integer, ToasterStatus> VALUE_MAP;
        private final String name;
        private final int value;

        private ToasterStatus(int value, String name) {
            this.value = value;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public int getIntValue() {
            return this.value;
        }

        public static Optional<ToasterStatus> forName(String name) {
            return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
        }

        public static ToasterStatus forValue(int intValue) {
            return VALUE_MAP.get(intValue);
        }

        static {
            ImmutableMap.Builder nb = ImmutableMap.builder();
            ImmutableMap.Builder vb = ImmutableMap.builder();
            for (ToasterStatus enumItem : ToasterStatus.values()) {
                vb.put((Object)enumItem.value, (Object)enumItem);
                nb.put((Object)enumItem.name, (Object)enumItem);
            }
            NAME_MAP = nb.build();
            VALUE_MAP = vb.build();
        }
    }
}

