/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeRef;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.NodeUpdated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.node.NodeConnectorKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NodeUpdatedBuilder
implements Builder<NodeUpdated> {
    private NodeId _id;
    private Map<NodeConnectorKey, NodeConnector> _nodeConnector;
    private NodeRef _nodeRef;
    Map<Class<? extends Augmentation<NodeUpdated>>, Augmentation<NodeUpdated>> augmentation = Collections.emptyMap();

    public NodeUpdatedBuilder() {
    }

    public NodeUpdatedBuilder(Node arg) {
        this._id = arg.getId();
        this._nodeConnector = arg.getNodeConnector();
    }

    public NodeUpdatedBuilder(NodeUpdated base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NodeUpdated>>, Augmentation<NodeUpdated>>(aug);
        }
        this._id = base.getId();
        this._nodeConnector = base.getNodeConnector();
        this._nodeRef = base.getNodeRef();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Node) {
            this._id = ((Node)arg).getId();
            this._nodeConnector = ((Node)arg).getNodeConnector();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Node]");
    }

    public NodeId getId() {
        return this._id;
    }

    public Map<NodeConnectorKey, NodeConnector> getNodeConnector() {
        return this._nodeConnector;
    }

    public NodeRef getNodeRef() {
        return this._nodeRef;
    }

    public <E$$ extends Augmentation<NodeUpdated>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public NodeUpdatedBuilder setId(NodeId value) {
        this._id = value;
        return this;
    }

    public NodeUpdatedBuilder setNodeConnector(Map<NodeConnectorKey, NodeConnector> values) {
        this._nodeConnector = values;
        return this;
    }

    @Deprecated(forRemoval=true)
    public NodeUpdatedBuilder setNodeConnector(List<NodeConnector> values) {
        return this.setNodeConnector(CodeHelpers.compatMap(values));
    }

    public NodeUpdatedBuilder setNodeRef(NodeRef value) {
        this._nodeRef = value;
        return this;
    }

    public NodeUpdatedBuilder addAugmentation(Augmentation<NodeUpdated> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NodeUpdated>>, Augmentation<NodeUpdated>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NodeUpdatedBuilder removeAugmentation(Class<? extends Augmentation<NodeUpdated>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NodeUpdated build() {
        return new NodeUpdatedImpl(this);
    }

    @Deprecated
    private static final class NodeUpdatedImpl
    extends AbstractAugmentable<NodeUpdated>
    implements NodeUpdated {
        private final NodeId _id;
        private final Map<NodeConnectorKey, NodeConnector> _nodeConnector;
        private final NodeRef _nodeRef;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NodeUpdatedImpl(NodeUpdatedBuilder base) {
            super(base.augmentation);
            this._id = base.getId();
            this._nodeConnector = CodeHelpers.emptyToNull(base.getNodeConnector());
            this._nodeRef = base.getNodeRef();
        }

        @Override
        public NodeId getId() {
            return this._id;
        }

        @Override
        public Map<NodeConnectorKey, NodeConnector> getNodeConnector() {
            return this._nodeConnector;
        }

        @Override
        public NodeRef getNodeRef() {
            return this._nodeRef;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = NodeUpdated.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return NodeUpdated.bindingEquals(this, obj);
        }

        public String toString() {
            return NodeUpdated.bindingToString(this);
        }
    }
}

