/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.Nodes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.Node;
import org.opendaylight.yang.gen.v1.urn.opendaylight.inventory.rev130819.nodes.NodeKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

public class NodesBuilder
implements Builder<Nodes> {
    private Map<NodeKey, Node> _node;
    Map<Class<? extends Augmentation<Nodes>>, Augmentation<Nodes>> augmentation = Collections.emptyMap();

    public NodesBuilder() {
    }

    public NodesBuilder(Nodes base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Nodes>>, Augmentation<Nodes>>(aug);
        }
        this._node = base.getNode();
    }

    public Map<NodeKey, Node> getNode() {
        return this._node;
    }

    public <E$$ extends Augmentation<Nodes>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public NodesBuilder setNode(Map<NodeKey, Node> values) {
        this._node = values;
        return this;
    }

    @Deprecated(forRemoval=true)
    public NodesBuilder setNode(List<Node> values) {
        return this.setNode(CodeHelpers.compatMap(values));
    }

    public NodesBuilder addAugmentation(Augmentation<Nodes> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Nodes>>, Augmentation<Nodes>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NodesBuilder removeAugmentation(Class<? extends Augmentation<Nodes>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Nodes build() {
        return new NodesImpl(this);
    }

    private static final class NodesImpl
    extends AbstractAugmentable<Nodes>
    implements Nodes {
        private final Map<NodeKey, Node> _node;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NodesImpl(NodesBuilder base) {
            super(base.augmentation);
            this._node = CodeHelpers.emptyToNull(base.getNode());
        }

        @Override
        public Map<NodeKey, Node> getNode() {
            return this._node;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Nodes.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Nodes.bindingEquals(this, obj);
        }

        public String toString() {
            return Nodes.bindingToString(this);
        }
    }
}

