/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.stmt;

import com.google.common.base.Verify;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;

public interface OrderedByStatement
extends DeclaredStatement<Ordering> {
    @Override
    default public StatementDefinition statementDefinition() {
        return YangStmtMapping.ORDERED_BY;
    }

    default public @NonNull Ordering getValue() {
        return (Ordering)((Object)Verify.verifyNotNull((Object)((Object)((Ordering)((Object)this.argument())))));
    }

    @NonNullByDefault
    public static enum Ordering {
        SYSTEM("system"),
        USER("user");

        private String argumentString;

        private Ordering(String argumentString) {
            this.argumentString = argumentString;
        }

        public String getArgumentString() {
            return this.argumentString;
        }

        public static Ordering forArgumentString(String argumentString) {
            switch (argumentString) {
                case "system": {
                    return SYSTEM;
                }
                case "user": {
                    return USER;
                }
            }
            throw new IllegalArgumentException("Invalid ordering string '" + argumentString + "'");
        }
    }
}

