/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.api.stmt;

import com.google.common.annotations.Beta;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Immutable;

@Beta
@NonNullByDefault
public final class PatternExpression
implements Immutable {
    private final String pattern;
    private final String regex;

    private PatternExpression(String regex, String pattern) {
        this.regex = Objects.requireNonNull(regex);
        this.pattern = Objects.requireNonNull(pattern);
    }

    public static PatternExpression of(String regex, String pattern) {
        return new PatternExpression(regex, pattern);
    }

    public String getJavaPatternString() {
        return this.pattern;
    }

    public String getRegularExpressionString() {
        return this.regex;
    }

    public int hashCode() {
        return this.regex.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PatternExpression)) {
            return false;
        }
        PatternExpression other = (PatternExpression)obj;
        return this.regex.equals(other.regex) && this.pattern.equals(other.pattern);
    }

    public String toString() {
        return this.regex;
    }
}

