/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.URI;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.concepts.WritableObject;
import org.opendaylight.yangtools.util.AbstractIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.DSIv1;

@Beta
@NonNullByDefault
public final class DatastoreIdentifier
extends AbstractIdentifier<QName>
implements WritableObject {
    private static final long serialVersionUID = 1L;
    private static final URI IETF_DATASTORES_NAMESPACE = URI.create("urn:ietf:params:xml:ns:yang:ietf-datastores");
    private static final ImmutableSet<String> KNOWN_ABSTRACTS = ImmutableSet.of((Object)"datastore", (Object)"conventional", (Object)"dynamic");
    private static final LoadingCache<QName, DatastoreIdentifier> CACHE = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<QName, DatastoreIdentifier>(){

        public DatastoreIdentifier load(QName key) {
            return DatastoreIdentifier.of(key);
        }
    });

    private DatastoreIdentifier(QName qname) {
        super((Object)qname);
        if (IETF_DATASTORES_NAMESPACE.equals(qname.getNamespace())) {
            Preconditions.checkArgument((!KNOWN_ABSTRACTS.contains((Object)qname.getLocalName()) ? 1 : 0) != 0, (String)"%s refers to a known-abstract datastore", (Object)qname);
        }
    }

    public static DatastoreIdentifier of(QName qname) {
        return new DatastoreIdentifier(qname);
    }

    public static DatastoreIdentifier create(QName qname) {
        DatastoreIdentifier existing = (DatastoreIdentifier)((Object)CACHE.getIfPresent((Object)qname));
        return existing != null ? existing : (DatastoreIdentifier)((Object)CACHE.getUnchecked((Object)qname.intern()));
    }

    public static DatastoreIdentifier readFrom(DataInput in) throws IOException {
        return DatastoreIdentifier.create(QName.readFrom((DataInput)in));
    }

    public void writeTo(DataOutput out) throws IOException {
        ((QName)this.getValue()).writeTo(out);
    }

    private Object writeReplace() {
        return new DSIv1((QName)this.getValue());
    }
}

