/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.codec;

import com.google.common.annotations.Beta;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.RpcError;
import org.opendaylight.yangtools.yang.common.YangError;
import org.opendaylight.yangtools.yang.model.api.ConstraintMetaDefinition;

@Beta
public class YangInvalidValueException
extends IllegalArgumentException
implements YangError {
    private static final long serialVersionUID = 1L;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull RpcError.ErrorType errorType;
    private final @Nullable String errorAppTag;
    private final @Nullable String errorMessage;

    public YangInvalidValueException(RpcError.ErrorType errorType, ConstraintMetaDefinition constraint, String message) {
        super(Objects.requireNonNull(message));
        this.errorType = Objects.requireNonNull(errorType);
        this.errorAppTag = constraint.getErrorAppTag().orElse(null);
        this.errorMessage = constraint.getErrorMessage().orElse(null);
    }

    public final RpcError.ErrorType getErrorType() {
        return this.errorType;
    }

    public final RpcError.ErrorSeverity getSeverity() {
        return RpcError.ErrorSeverity.ERROR;
    }

    public final String getErrorTag() {
        return "invalid-value";
    }

    public final Optional<String> getErrorAppTag() {
        return Optional.ofNullable(this.errorAppTag);
    }

    public final Optional<String> getErrorMessage() {
        return Optional.ofNullable(this.errorMessage);
    }
}

