/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.tree;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.CursorAwareDataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNodes;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModification;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeModificationCursor;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DefaultDataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;
import org.opendaylight.yangtools.yang.data.api.schema.tree.NormalizedNodeDataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.TerminalDataTreeCandidateNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class DataTreeCandidates {
    private static final Logger LOG = LoggerFactory.getLogger(DataTreeCandidates.class);

    private DataTreeCandidates() {
    }

    public static @NonNull DataTreeCandidate newDataTreeCandidate(YangInstanceIdentifier rootPath, DataTreeCandidateNode rootNode) {
        return new DefaultDataTreeCandidate(rootPath, rootNode);
    }

    public static @NonNull DataTreeCandidate fromNormalizedNode(YangInstanceIdentifier rootPath, NormalizedNode<?, ?> node) {
        return new DefaultDataTreeCandidate(rootPath, new NormalizedNodeDataTreeCandidateNode(node));
    }

    public static void applyToCursor(DataTreeModificationCursor cursor, DataTreeCandidate candidate) {
        DataTreeCandidateNodes.applyToCursor(cursor, candidate.getRootNode());
    }

    public static void applyToModification(DataTreeModification modification, DataTreeCandidate candidate) {
        if (modification instanceof CursorAwareDataTreeModification) {
            DataTreeCandidates.applyToCursorAwareModification((CursorAwareDataTreeModification)modification, candidate);
            return;
        }
        DataTreeCandidateNode node = candidate.getRootNode();
        YangInstanceIdentifier path = candidate.getRootPath();
        switch (node.getModificationType()) {
            case DELETE: {
                modification.delete(path);
                LOG.debug("Modification {} deleted path {}", (Object)modification, (Object)path);
                break;
            }
            case SUBTREE_MODIFIED: {
                LOG.debug("Modification {} modified path {}", (Object)modification, (Object)path);
                NodeIterator iterator = new NodeIterator(null, path, node.getChildNodes().iterator());
                while ((iterator = iterator.next(modification)) != null) {
                }
                break;
            }
            case UNMODIFIED: {
                LOG.debug("Modification {} unmodified path {}", (Object)modification, (Object)path);
                break;
            }
            case WRITE: {
                modification.write(path, node.getDataAfter().get());
                LOG.debug("Modification {} written path {}", (Object)modification, (Object)path);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported modification " + node.getModificationType());
            }
        }
    }

    public static @NonNull DataTreeCandidate aggregate(@NonNull List<? extends DataTreeCandidate> candidates) {
        Iterator<? extends DataTreeCandidate> it = candidates.iterator();
        Preconditions.checkArgument((boolean)it.hasNext(), (Object)"Input must not be empty");
        DataTreeCandidate first = Objects.requireNonNull(it.next(), "Input must not contain null entries");
        if (!it.hasNext()) {
            return first;
        }
        YangInstanceIdentifier rootPath = first.getRootPath();
        ArrayList<DataTreeCandidateNode> roots = new ArrayList<DataTreeCandidateNode>(candidates.size());
        roots.add(first.getRootNode());
        it.forEachRemaining(candidate -> {
            YangInstanceIdentifier root = candidate.getRootPath();
            Preconditions.checkArgument((boolean)rootPath.equals(root), (String)"Expecting root path %s, encountered %s", (Object)rootPath, (Object)root);
            roots.add(candidate.getRootNode());
        });
        return DataTreeCandidates.newDataTreeCandidate(rootPath, DataTreeCandidates.fastCompressNode((DataTreeCandidateNode)roots.get(0), roots));
    }

    private static DataTreeCandidateNode fastCompressNode(DataTreeCandidateNode first, List<DataTreeCandidateNode> input) {
        DataTreeCandidateNode last = input.get(input.size() - 1);
        ModificationType nodeModification = last.getModificationType();
        Optional<NormalizedNode<?, ?>> dataBefore = first.getDataBefore();
        Optional<NormalizedNode<?, ?>> dataAfter = last.getDataAfter();
        switch (nodeModification) {
            case DELETE: {
                ModificationType previous = first.getModificationType();
                if (previous == ModificationType.DELETE || previous == ModificationType.DISAPPEARED || previous == ModificationType.UNMODIFIED && dataBefore.isEmpty()) {
                    DataTreeCandidates.illegalModification(ModificationType.DELETE, ModificationType.DELETE);
                }
                if (dataBefore.isEmpty()) {
                    return new TerminalDataTreeCandidateNode(null, ModificationType.UNMODIFIED, null, null);
                }
                return new TerminalDataTreeCandidateNode(null, nodeModification, dataBefore.get(), null);
            }
            case WRITE: {
                return new TerminalDataTreeCandidateNode(null, nodeModification, dataBefore.orElse(null), dataAfter.orElseThrow());
            }
            case SUBTREE_MODIFIED: 
            case UNMODIFIED: 
            case APPEARED: 
            case DISAPPEARED: {
                return DataTreeCandidates.slowCompressNodes(first, input);
            }
        }
        throw new IllegalStateException("Unsupported modification type " + nodeModification);
    }

    private static DataTreeCandidateNode slowCompressNodes(DataTreeCandidateNode first, List<DataTreeCandidateNode> input) {
        TerminalDataTreeCandidateNode finalNode = new TerminalDataTreeCandidateNode(null, first.getDataBefore().orElse(null));
        input.forEach(node -> DataTreeCandidates.compressNode(finalNode, node, null));
        finalNode.setAfter(input.get(input.size() - 1).getDataAfter().orElse(null));
        return DataTreeCandidates.cleanUpTree(finalNode);
    }

    private static void compressNode(TerminalDataTreeCandidateNode finalNode, DataTreeCandidateNode node, YangInstanceIdentifier.PathArgument parent) {
        YangInstanceIdentifier.PathArgument identifier;
        try {
            identifier = node.getIdentifier();
        }
        catch (IllegalStateException e) {
            identifier = null;
        }
        if (finalNode.getNode(identifier).isEmpty()) {
            TerminalDataTreeCandidateNode parentNode = finalNode.getNode(parent).orElseThrow(() -> new IllegalArgumentException("No node found for " + parent + " identifier"));
            TerminalDataTreeCandidateNode childNode = new TerminalDataTreeCandidateNode(identifier, node.getDataBefore().orElse(null), parentNode);
            parentNode.addChildNode(childNode);
        }
        ModificationType nodeModification = node.getModificationType();
        switch (nodeModification) {
            case UNMODIFIED: {
                break;
            }
            case DELETE: 
            case SUBTREE_MODIFIED: 
            case WRITE: 
            case APPEARED: 
            case DISAPPEARED: {
                finalNode.setModification(identifier, DataTreeCandidates.compressModifications(finalNode.getModification(identifier), nodeModification, finalNode.getDataAfter(identifier).isEmpty()));
                finalNode.setData(identifier, node.getDataAfter().orElse(null));
                for (DataTreeCandidateNode child : node.getChildNodes()) {
                    DataTreeCandidates.compressNode(finalNode, child, identifier);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported modification type " + nodeModification);
            }
        }
    }

    private static DataTreeCandidateNode cleanUpTree(TerminalDataTreeCandidateNode finalNode) {
        return DataTreeCandidates.cleanUpTree(finalNode, finalNode);
    }

    private static DataTreeCandidateNode cleanUpTree(TerminalDataTreeCandidateNode finalNode, TerminalDataTreeCandidateNode node) {
        YangInstanceIdentifier.PathArgument identifier = node.getIdentifier();
        ModificationType nodeModification = node.getModificationType();
        Collection<DataTreeCandidateNode> childNodes = node.getChildNodes();
        Iterator<DataTreeCandidateNode> iterator = childNodes.iterator();
        while (iterator.hasNext()) {
            DataTreeCandidates.cleanUpTree(finalNode, (TerminalDataTreeCandidateNode)iterator.next());
        }
        Optional<NormalizedNode<?, ?>> dataBefore = finalNode.getDataBefore(identifier);
        switch (nodeModification) {
            case UNMODIFIED: {
                finalNode.deleteNode(identifier);
                return finalNode;
            }
            case WRITE: {
                return finalNode;
            }
            case DELETE: {
                if (dataBefore.isEmpty()) {
                    finalNode.deleteNode(identifier);
                }
                return finalNode;
            }
            case APPEARED: {
                if (dataBefore.isPresent()) {
                    DataTreeCandidates.illegalModification(ModificationType.APPEARED, ModificationType.WRITE);
                }
                if (childNodes.isEmpty()) {
                    finalNode.deleteNode(identifier);
                }
                return finalNode;
            }
            case DISAPPEARED: {
                if (dataBefore.isEmpty() || childNodes.isEmpty()) {
                    finalNode.deleteNode(identifier);
                }
                return finalNode;
            }
            case SUBTREE_MODIFIED: {
                if (dataBefore.isEmpty()) {
                    DataTreeCandidates.illegalModification(ModificationType.SUBTREE_MODIFIED, ModificationType.DELETE);
                }
                if (childNodes.isEmpty()) {
                    finalNode.deleteNode(identifier);
                }
                return finalNode;
            }
        }
        throw new IllegalStateException("Unsupported modification type " + nodeModification);
    }

    private static ModificationType compressModifications(ModificationType firstModification, ModificationType secondModification, boolean hasNoDataBefore) {
        switch (firstModification) {
            case UNMODIFIED: {
                if (hasNoDataBefore) {
                    switch (secondModification) {
                        case UNMODIFIED: 
                        case WRITE: 
                        case APPEARED: {
                            return secondModification;
                        }
                        case DELETE: {
                            return DataTreeCandidates.illegalModification(ModificationType.DELETE, ModificationType.DELETE);
                        }
                        case SUBTREE_MODIFIED: {
                            return DataTreeCandidates.illegalModification(ModificationType.SUBTREE_MODIFIED, ModificationType.DELETE);
                        }
                        case DISAPPEARED: {
                            return DataTreeCandidates.illegalModification(ModificationType.DISAPPEARED, ModificationType.DELETE);
                        }
                    }
                    throw new IllegalStateException("Unsupported modification type " + secondModification);
                }
                if (secondModification == ModificationType.APPEARED) {
                    return DataTreeCandidates.illegalModification(ModificationType.APPEARED, ModificationType.WRITE);
                }
                return secondModification;
            }
            case WRITE: {
                switch (secondModification) {
                    case SUBTREE_MODIFIED: 
                    case UNMODIFIED: 
                    case WRITE: {
                        return ModificationType.WRITE;
                    }
                    case DELETE: {
                        return ModificationType.DELETE;
                    }
                    case DISAPPEARED: {
                        return ModificationType.DISAPPEARED;
                    }
                    case APPEARED: {
                        return DataTreeCandidates.illegalModification(ModificationType.APPEARED, firstModification);
                    }
                }
                throw new IllegalStateException("Unsupported modification type " + secondModification);
            }
            case DELETE: {
                switch (secondModification) {
                    case UNMODIFIED: {
                        return ModificationType.DELETE;
                    }
                    case WRITE: 
                    case APPEARED: {
                        return ModificationType.WRITE;
                    }
                    case DELETE: {
                        return DataTreeCandidates.illegalModification(ModificationType.DELETE, firstModification);
                    }
                    case DISAPPEARED: {
                        return DataTreeCandidates.illegalModification(ModificationType.DISAPPEARED, firstModification);
                    }
                    case SUBTREE_MODIFIED: {
                        return DataTreeCandidates.illegalModification(ModificationType.SUBTREE_MODIFIED, firstModification);
                    }
                }
                throw new IllegalStateException("Unsupported modification type " + secondModification);
            }
            case APPEARED: {
                switch (secondModification) {
                    case SUBTREE_MODIFIED: 
                    case UNMODIFIED: {
                        return ModificationType.APPEARED;
                    }
                    case DELETE: 
                    case DISAPPEARED: {
                        return ModificationType.UNMODIFIED;
                    }
                    case WRITE: {
                        return ModificationType.WRITE;
                    }
                    case APPEARED: {
                        return DataTreeCandidates.illegalModification(ModificationType.APPEARED, firstModification);
                    }
                }
                throw new IllegalStateException("Unsupported modification type " + secondModification);
            }
            case DISAPPEARED: {
                switch (secondModification) {
                    case UNMODIFIED: 
                    case WRITE: {
                        return secondModification;
                    }
                    case APPEARED: {
                        return ModificationType.SUBTREE_MODIFIED;
                    }
                    case DELETE: {
                        return DataTreeCandidates.illegalModification(ModificationType.DELETE, firstModification);
                    }
                    case DISAPPEARED: {
                        return DataTreeCandidates.illegalModification(ModificationType.DISAPPEARED, firstModification);
                    }
                    case SUBTREE_MODIFIED: {
                        return DataTreeCandidates.illegalModification(ModificationType.SUBTREE_MODIFIED, firstModification);
                    }
                }
                throw new IllegalStateException("Unsupported modification type " + secondModification);
            }
            case SUBTREE_MODIFIED: {
                switch (secondModification) {
                    case SUBTREE_MODIFIED: 
                    case UNMODIFIED: {
                        return ModificationType.SUBTREE_MODIFIED;
                    }
                    case DELETE: 
                    case WRITE: 
                    case DISAPPEARED: {
                        return secondModification;
                    }
                    case APPEARED: {
                        return DataTreeCandidates.illegalModification(ModificationType.APPEARED, firstModification);
                    }
                }
                throw new IllegalStateException("Unsupported modification type " + secondModification);
            }
        }
        throw new IllegalStateException("Unsupported modification type " + secondModification);
    }

    private static ModificationType illegalModification(ModificationType first, ModificationType second) {
        throw new IllegalArgumentException(first + " modification event on " + second + " node");
    }

    private static void applyToCursorAwareModification(CursorAwareDataTreeModification modification, DataTreeCandidate candidate) {
        YangInstanceIdentifier candidatePath = candidate.getRootPath();
        YangInstanceIdentifier parent = candidatePath.getParent();
        if (parent == null) {
            try (DataTreeModificationCursor cursor = modification.openCursor();){
                DataTreeCandidateNodes.applyRootToCursor(cursor, candidate.getRootNode());
            }
        }
        try (DataTreeModificationCursor cursor = modification.openCursor(parent).orElseThrow();){
            DataTreeCandidateNodes.applyRootedNodeToCursor(cursor, candidatePath, candidate.getRootNode());
        }
    }

    private static final class NodeIterator {
        private final Iterator<DataTreeCandidateNode> iterator;
        private final YangInstanceIdentifier path;
        private final NodeIterator parent;

        NodeIterator(@Nullable NodeIterator parent, YangInstanceIdentifier path, Iterator<DataTreeCandidateNode> iterator) {
            this.iterator = Objects.requireNonNull(iterator);
            this.path = Objects.requireNonNull(path);
            this.parent = parent;
        }

        NodeIterator next(DataTreeModification modification) {
            block6: while (this.iterator.hasNext()) {
                DataTreeCandidateNode node = this.iterator.next();
                YangInstanceIdentifier child = this.path.node(node.getIdentifier());
                switch (node.getModificationType()) {
                    case DELETE: {
                        modification.delete(child);
                        LOG.debug("Modification {} deleted path {}", (Object)modification, (Object)child);
                        continue block6;
                    }
                    case SUBTREE_MODIFIED: 
                    case APPEARED: 
                    case DISAPPEARED: {
                        LOG.debug("Modification {} modified path {}", (Object)modification, (Object)child);
                        return new NodeIterator(this, child, node.getChildNodes().iterator());
                    }
                    case UNMODIFIED: {
                        LOG.debug("Modification {} unmodified path {}", (Object)modification, (Object)child);
                        continue block6;
                    }
                    case WRITE: {
                        modification.write(child, node.getDataAfter().get());
                        LOG.debug("Modification {} written path {}", (Object)modification, (Object)child);
                        continue block6;
                    }
                }
                throw new IllegalArgumentException("Unsupported modification " + node.getModificationType());
            }
            return this.parent;
        }
    }
}

