/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.tree;

import com.google.common.annotations.Beta;
import java.util.OptionalInt;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataValidationFailedException;

@Beta
@NonNullByDefault
public final class RequiredElementCountException
extends DataValidationFailedException {
    private static final long serialVersionUID = 1L;
    private final int actualCount;
    private final int minimumCount;
    private final int maximumCount;

    public RequiredElementCountException(YangInstanceIdentifier path, int actualCount, int minimumCount, int maximumCount, String message) {
        super(path, message);
        this.minimumCount = minimumCount;
        this.maximumCount = maximumCount;
        this.actualCount = actualCount;
    }

    public RequiredElementCountException(YangInstanceIdentifier path, int actualCount, int minimumCount, int maximumCount, String format, Object ... args) {
        this(path, actualCount, minimumCount, maximumCount, String.format(format, args));
    }

    public OptionalInt getMinimumCount() {
        return this.minimumCount == 0 ? OptionalInt.empty() : OptionalInt.of(this.minimumCount);
    }

    public OptionalInt getMaximumCount() {
        return this.maximumCount == Integer.MAX_VALUE ? OptionalInt.empty() : OptionalInt.of(this.maximumCount);
    }

    public int getActualCount() {
        return this.actualCount;
    }
}

