/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.api.schema.tree;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;

class TerminalDataTreeCandidateNode
implements DataTreeCandidateNode {
    private ModificationType modificationType;
    private final YangInstanceIdentifier.PathArgument identifier;
    private final NormalizedNode<?, ?> before;
    private NormalizedNode<?, ?> after;
    private final HashMap<YangInstanceIdentifier.PathArgument, TerminalDataTreeCandidateNode> childNodes = new HashMap();
    private TerminalDataTreeCandidateNode parentNode;

    TerminalDataTreeCandidateNode(YangInstanceIdentifier.PathArgument identifier, NormalizedNode<?, ?> data, TerminalDataTreeCandidateNode parentNode) {
        this(identifier, data);
        this.parentNode = Objects.requireNonNull(parentNode);
    }

    TerminalDataTreeCandidateNode(YangInstanceIdentifier.PathArgument identifier, NormalizedNode<?, ?> data) {
        this(identifier, ModificationType.UNMODIFIED, data, data);
    }

    TerminalDataTreeCandidateNode(YangInstanceIdentifier.PathArgument identifier, ModificationType modificationType, NormalizedNode<?, ?> before, NormalizedNode<?, ?> after) {
        this.modificationType = modificationType;
        this.identifier = identifier;
        this.before = before;
        this.after = after;
    }

    @Override
    public YangInstanceIdentifier.PathArgument getIdentifier() {
        return this.identifier;
    }

    @Override
    public Collection<DataTreeCandidateNode> getChildNodes() {
        return Collections.unmodifiableCollection(this.childNodes.values());
    }

    @Override
    public Optional<DataTreeCandidateNode> getModifiedChild(YangInstanceIdentifier.PathArgument childIdentifier) {
        return Optional.ofNullable((DataTreeCandidateNode)this.childNodes.get(this.identifier));
    }

    @Override
    public ModificationType getModificationType() {
        return this.modificationType;
    }

    @Override
    public Optional<NormalizedNode<?, ?>> getDataAfter() {
        return Optional.ofNullable(this.after);
    }

    @NonNull Optional<NormalizedNode<?, ?>> getDataAfter(YangInstanceIdentifier.PathArgument id) {
        return this.getNode(id).flatMap(TerminalDataTreeCandidateNode::getDataAfter);
    }

    @Override
    public Optional<NormalizedNode<?, ?>> getDataBefore() {
        return Optional.ofNullable(this.before);
    }

    @NonNull Optional<NormalizedNode<?, ?>> getDataBefore(YangInstanceIdentifier.PathArgument id) {
        Optional<TerminalDataTreeCandidateNode> node = this.getNode(id);
        if (node.isPresent()) {
            return node.get().getDataBefore();
        }
        return Optional.empty();
    }

    void setAfter(NormalizedNode<?, ?> after) {
        this.after = after;
    }

    void addChildNode(TerminalDataTreeCandidateNode node) {
        this.childNodes.put(node.getIdentifier(), node);
    }

    void setModification(YangInstanceIdentifier.PathArgument id, ModificationType modification) {
        Optional<TerminalDataTreeCandidateNode> node = this.getNode(id);
        if (node.isEmpty()) {
            throw new IllegalArgumentException("No node with " + id + " id was found");
        }
        node.get().setModification(modification);
    }

    private void setModification(ModificationType modification) {
        this.modificationType = modification;
    }

    ModificationType getModification(YangInstanceIdentifier.PathArgument id) {
        Optional<TerminalDataTreeCandidateNode> node = this.getNode(id);
        return node.isEmpty() ? ModificationType.UNMODIFIED : node.get().getModificationType();
    }

    void deleteNode(YangInstanceIdentifier.PathArgument id) {
        if (id == null) {
            this.modificationType = ModificationType.UNMODIFIED;
            return;
        }
        Optional<TerminalDataTreeCandidateNode> node = this.getNode(id);
        if (node.isEmpty()) {
            throw new IllegalArgumentException("No node with " + id + " id was found");
        }
        node.get().parentNode.deleteChild(id);
    }

    private void deleteChild(YangInstanceIdentifier.PathArgument id) {
        this.childNodes.remove(id);
    }

    @NonNull Optional<TerminalDataTreeCandidateNode> getNode(YangInstanceIdentifier.PathArgument id) {
        if (id == null) {
            return Optional.of(this);
        }
        if (this.childNodes.isEmpty()) {
            return Optional.empty();
        }
        if (this.childNodes.containsKey(id)) {
            return Optional.ofNullable(this.childNodes.get(id));
        }
        return this.findNode(id);
    }

    void setData(YangInstanceIdentifier.PathArgument id, NormalizedNode<?, ?> node) {
        TerminalDataTreeCandidateNode terminalDataTreeCandidateNode = this.getNode(id).get();
        terminalDataTreeCandidateNode.setAfter(node);
    }

    private @NonNull Optional<TerminalDataTreeCandidateNode> findNode(YangInstanceIdentifier.PathArgument id) {
        HashSet<HashMap<YangInstanceIdentifier.PathArgument, TerminalDataTreeCandidateNode>> nodes = new HashSet<HashMap<YangInstanceIdentifier.PathArgument, TerminalDataTreeCandidateNode>>();
        this.childNodes.forEach((childIdentifier, childNode) -> nodes.add(childNode.childNodes));
        return this.findNode(nodes, id);
    }

    private @NonNull Optional<TerminalDataTreeCandidateNode> findNode(Collection<HashMap<YangInstanceIdentifier.PathArgument, TerminalDataTreeCandidateNode>> nodes, YangInstanceIdentifier.PathArgument id) {
        if (nodes.isEmpty()) {
            return Optional.empty();
        }
        HashSet<HashMap<YangInstanceIdentifier.PathArgument, TerminalDataTreeCandidateNode>> nextNodes = new HashSet<HashMap<YangInstanceIdentifier.PathArgument, TerminalDataTreeCandidateNode>>();
        for (HashMap<YangInstanceIdentifier.PathArgument, TerminalDataTreeCandidateNode> map : nodes) {
            if (map.containsKey(id)) {
                return Optional.ofNullable(map.get(id));
            }
            map.forEach((childIdentifier, childNode) -> nextNodes.add(childNode.childNodes));
        }
        return this.findNode(nextNodes, id);
    }
}

