/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.runtime.osgi.impl;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.primitives.UnsignedLong;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.osgi.OSGiBindingRuntimeContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Component(factory="org.opendaylight.mdsal.binding.runtime.osgi.impl.OSGiBindingRuntimeContextImpl", service={OSGiBindingRuntimeContext.class})
public final class OSGiBindingRuntimeContextImpl
implements OSGiBindingRuntimeContext {
    static final String FACTORY_NAME = "org.opendaylight.mdsal.binding.runtime.osgi.impl.OSGiBindingRuntimeContextImpl";
    @VisibleForTesting
    static final String GENERATION = "org.opendaylight.mdsal.binding.runtime.osgi.impl.Generation";
    @VisibleForTesting
    static final String DELEGATE = "org.opendaylight.mdsal.binding.runtime.osgi.impl.BindingRuntimeContext";
    private static final Logger LOG = LoggerFactory.getLogger(OSGiBindingRuntimeContextImpl.class);
    private BindingRuntimeContext delegate;
    private UnsignedLong generation;

    public UnsignedLong getGeneration() {
        return (UnsignedLong)Verify.verifyNotNull((Object)this.generation);
    }

    public BindingRuntimeContext getService() {
        return (BindingRuntimeContext)Verify.verifyNotNull((Object)this.delegate);
    }

    @Activate
    void activate(Map<String, ?> properties) {
        this.generation = (UnsignedLong)Verify.verifyNotNull(properties.get(GENERATION));
        this.delegate = (BindingRuntimeContext)Verify.verifyNotNull(properties.get(DELEGATE));
        LOG.info("BindingRuntimeContext generation {} activated", (Object)this.generation);
    }

    @Deactivate
    void deactivate() {
        this.delegate = null;
        LOG.info("BindingRuntimeContext generation {} deactivated", (Object)this.generation);
    }

    @SuppressModernizer
    static Dictionary<String, ?> props(@NonNull UnsignedLong generation, @NonNull Integer ranking, BindingRuntimeContext delegate) {
        Hashtable<String, Integer> ret = new Hashtable<String, Integer>(4);
        ((Dictionary)ret).put("service.ranking", ranking);
        ((Dictionary)ret).put(GENERATION, (Integer)generation);
        ((Dictionary)ret).put(DELEGATE, (Integer)Objects.requireNonNull(delegate));
        return ret;
    }
}

