/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.entityownership;

import akka.actor.ActorRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.controller.cluster.datastore.ShardDataTree;
import org.opendaylight.controller.cluster.entityownership.EntityOwnersModel;
import org.opendaylight.controller.cluster.entityownership.messages.CandidateAdded;
import org.opendaylight.controller.cluster.entityownership.messages.CandidateRemoved;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.EntityType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type.entity.Candidate;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidateNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CandidateListChangeListener
implements DOMDataTreeChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(CandidateListChangeListener.class);
    private final String logId;
    private final ActorRef shard;
    private final Map<YangInstanceIdentifier, Collection<String>> currentCandidates = new HashMap<YangInstanceIdentifier, Collection<String>>();

    CandidateListChangeListener(ActorRef shard, String logId) {
        this.shard = Objects.requireNonNull(shard, "shard should not be null");
        this.logId = logId;
    }

    void init(ShardDataTree shardDataTree) {
        shardDataTree.registerTreeChangeListener(YangInstanceIdentifier.builder((YangInstanceIdentifier)EntityOwnersModel.ENTITY_OWNERS_PATH).node(EntityType.QNAME).node(EntityType.QNAME).node(EntityOwnersModel.ENTITY_QNAME).node(EntityOwnersModel.ENTITY_QNAME).node(Candidate.QNAME).node(Candidate.QNAME).build(), (DOMDataTreeChangeListener)this, Optional.empty(), noop -> {});
    }

    public void onDataTreeChanged(Collection<DataTreeCandidate> changes) {
        for (DataTreeCandidate change : changes) {
            Collection<String> newCandidates;
            DataTreeCandidateNode changeRoot = change.getRootNode();
            ModificationType type = changeRoot.getModificationType();
            LOG.debug("{}: Candidate node changed: {}, {}", new Object[]{this.logId, type, change.getRootPath()});
            YangInstanceIdentifier.NodeIdentifierWithPredicates candidateKey = (YangInstanceIdentifier.NodeIdentifierWithPredicates)change.getRootPath().getLastPathArgument();
            String candidate = candidateKey.getValue(EntityOwnersModel.CANDIDATE_NAME_QNAME).toString();
            YangInstanceIdentifier entityId = CandidateListChangeListener.extractEntityPath(change.getRootPath());
            if (type == ModificationType.WRITE || type == ModificationType.APPEARED) {
                LOG.debug("{}: Candidate {} was added for entity {}", new Object[]{this.logId, candidate, entityId});
                newCandidates = this.addToCurrentCandidates(entityId, candidate);
                this.shard.tell((Object)new CandidateAdded(entityId, candidate, new ArrayList<String>(newCandidates)), this.shard);
                continue;
            }
            if (type != ModificationType.DELETE && type != ModificationType.DISAPPEARED) continue;
            LOG.debug("{}: Candidate {} was removed for entity {}", new Object[]{this.logId, candidate, entityId});
            newCandidates = this.removeFromCurrentCandidates(entityId, candidate);
            this.shard.tell((Object)new CandidateRemoved(entityId, candidate, new ArrayList<String>(newCandidates)), this.shard);
        }
    }

    private Collection<String> addToCurrentCandidates(YangInstanceIdentifier entityId, String newCandidate) {
        Collection candidates = this.currentCandidates.computeIfAbsent(entityId, k -> new LinkedHashSet());
        candidates.add(newCandidate);
        return candidates;
    }

    private Collection<String> removeFromCurrentCandidates(YangInstanceIdentifier entityId, String candidateToRemove) {
        Collection<String> candidates = this.currentCandidates.get(entityId);
        if (candidates != null) {
            candidates.remove(candidateToRemove);
            return candidates;
        }
        return Collections.emptyList();
    }

    private static YangInstanceIdentifier extractEntityPath(YangInstanceIdentifier candidatePath) {
        ArrayList<YangInstanceIdentifier.PathArgument> newPathArgs = new ArrayList<YangInstanceIdentifier.PathArgument>();
        for (YangInstanceIdentifier.PathArgument pathArg : candidatePath.getPathArguments()) {
            newPathArgs.add(pathArg);
            if (!(pathArg instanceof YangInstanceIdentifier.NodeIdentifierWithPredicates) || !EntityOwnersModel.ENTITY_ID_QNAME.equals(((YangInstanceIdentifier.NodeIdentifierWithPredicates)pathArg).keySet().iterator().next())) continue;
            break;
        }
        return YangInstanceIdentifier.create(newPathArgs);
    }
}

