/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.entityownership;

import akka.actor.Props;
import akka.japi.Creator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import org.opendaylight.controller.cluster.common.actor.AbstractUntypedActor;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipChange;
import org.opendaylight.mdsal.eos.dom.api.DOMEntityOwnershipListener;

final class EntityOwnershipListenerActor
extends AbstractUntypedActor {
    private final DOMEntityOwnershipListener listener;

    private EntityOwnershipListenerActor(DOMEntityOwnershipListener listener) {
        this.listener = listener;
    }

    protected void handleReceive(Object message) {
        if (message instanceof DOMEntityOwnershipChange) {
            this.onEntityOwnershipChanged((DOMEntityOwnershipChange)message);
        } else {
            this.unknownMessage(message);
        }
    }

    private void onEntityOwnershipChanged(DOMEntityOwnershipChange change) {
        this.LOG.debug("Notifying EntityOwnershipListener {}: {}", (Object)this.listener, (Object)change);
        try {
            this.listener.ownershipChanged(change);
        }
        catch (Exception e) {
            this.LOG.error("Error notifying listener {}", (Object)this.listener, (Object)e);
        }
    }

    static Props props(DOMEntityOwnershipListener listener) {
        return Props.create(EntityOwnershipListenerActor.class, (Creator)new EntityOwnershipListenerCreator(listener));
    }

    private static final class EntityOwnershipListenerCreator
    implements Creator<EntityOwnershipListenerActor> {
        private static final long serialVersionUID = 1L;
        @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="This field is not Serializable but we don't create remote instances of this actor and thus don't need it to be Serializable.")
        private final DOMEntityOwnershipListener listener;

        EntityOwnershipListenerCreator(DOMEntityOwnershipListener listener) {
            this.listener = Objects.requireNonNull(listener);
        }

        public EntityOwnershipListenerActor create() {
            return new EntityOwnershipListenerActor(this.listener);
        }
    }
}

