/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.EntityType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.EntityTypeKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type.Entity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type.EntityKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

public class EntityTypeBuilder
implements Builder<EntityType> {
    private Map<EntityKey, Entity> _entity;
    private String _type;
    private EntityTypeKey key;
    Map<Class<? extends Augmentation<EntityType>>, Augmentation<EntityType>> augmentation = Collections.emptyMap();

    public EntityTypeBuilder() {
    }

    public EntityTypeBuilder(EntityType base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<EntityType>>, Augmentation<EntityType>>(aug);
        }
        this.key = base.key();
        this._type = base.getType();
        this._entity = base.getEntity();
    }

    public EntityTypeKey key() {
        return this.key;
    }

    public Map<EntityKey, Entity> getEntity() {
        return this._entity;
    }

    public String getType() {
        return this._type;
    }

    public <E$$ extends Augmentation<EntityType>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public EntityTypeBuilder withKey(EntityTypeKey key) {
        this.key = key;
        return this;
    }

    public EntityTypeBuilder setEntity(Map<EntityKey, Entity> values) {
        this._entity = values;
        return this;
    }

    @Deprecated(forRemoval=true)
    public EntityTypeBuilder setEntity(List<Entity> values) {
        return this.setEntity(CodeHelpers.compatMap(values));
    }

    public EntityTypeBuilder setType(String value) {
        this._type = value;
        return this;
    }

    public EntityTypeBuilder addAugmentation(Augmentation<EntityType> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<EntityType>>, Augmentation<EntityType>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public EntityTypeBuilder removeAugmentation(Class<? extends Augmentation<EntityType>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public EntityType build() {
        return new EntityTypeImpl(this);
    }

    private static final class EntityTypeImpl
    extends AbstractAugmentable<EntityType>
    implements EntityType {
        private final Map<EntityKey, Entity> _entity;
        private final String _type;
        private final EntityTypeKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        EntityTypeImpl(EntityTypeBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new EntityTypeKey(base.getType());
            this._type = this.key.getType();
            this._entity = CodeHelpers.emptyToNull(base.getEntity());
        }

        @Override
        public EntityTypeKey key() {
            return this.key;
        }

        @Override
        public Map<EntityKey, Entity> getEntity() {
            return this._entity;
        }

        @Override
        public String getType() {
            return this._type;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = EntityType.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return EntityType.bindingEquals(this, obj);
        }

        public String toString() {
            return EntityType.bindingToString(this);
        }
    }
}

