/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type.Entity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type.EntityKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.md.sal.clustering.entity.owners.rev150804.entity.owners.entity.type.entity.Candidate;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public class EntityBuilder
implements Builder<Entity> {
    private List<Candidate> _candidate;
    private InstanceIdentifier<?> _id;
    private String _owner;
    private EntityKey key;
    Map<Class<? extends Augmentation<Entity>>, Augmentation<Entity>> augmentation = Collections.emptyMap();

    public EntityBuilder() {
    }

    public EntityBuilder(Entity base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Entity>>, Augmentation<Entity>>(aug);
        }
        this.key = base.key();
        this._id = base.getId();
        this._candidate = base.getCandidate();
        this._owner = base.getOwner();
    }

    public EntityKey key() {
        return this.key;
    }

    public List<Candidate> getCandidate() {
        return this._candidate;
    }

    public InstanceIdentifier<?> getId() {
        return this._id;
    }

    public String getOwner() {
        return this._owner;
    }

    public <E$$ extends Augmentation<Entity>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public EntityBuilder withKey(EntityKey key) {
        this.key = key;
        return this;
    }

    public EntityBuilder setCandidate(List<Candidate> values) {
        this._candidate = values;
        return this;
    }

    public EntityBuilder setId(InstanceIdentifier<?> value) {
        this._id = value;
        return this;
    }

    public EntityBuilder setOwner(String value) {
        this._owner = value;
        return this;
    }

    public EntityBuilder addAugmentation(Augmentation<Entity> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Entity>>, Augmentation<Entity>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public EntityBuilder removeAugmentation(Class<? extends Augmentation<Entity>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Entity build() {
        return new EntityImpl(this);
    }

    private static final class EntityImpl
    extends AbstractAugmentable<Entity>
    implements Entity {
        private final List<Candidate> _candidate;
        private final InstanceIdentifier<?> _id;
        private final String _owner;
        private final EntityKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        EntityImpl(EntityBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new EntityKey(base.getId());
            this._id = this.key.getId();
            this._candidate = CodeHelpers.emptyToNull(base.getCandidate());
            this._owner = base.getOwner();
        }

        @Override
        public EntityKey key() {
            return this.key;
        }

        @Override
        public List<Candidate> getCandidate() {
            return this._candidate;
        }

        @Override
        public InstanceIdentifier<?> getId() {
            return this._id;
        }

        @Override
        public String getOwner() {
            return this._owner;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Entity.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Entity.bindingEquals(this, obj);
        }

        public String toString() {
            return Entity.bindingToString(this);
        }
    }
}

