/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.mdsal.dom.api.DOMDataTreeTransaction;
import org.opendaylight.mdsal.dom.spi.store.DOMStoreTransaction;

abstract class AbstractDOMForwardedCompositeTransaction<K, T extends DOMStoreTransaction>
implements DOMDataTreeTransaction {
    private final Map<K, T> backingTxs;
    private final Object identifier;

    protected AbstractDOMForwardedCompositeTransaction(Object identifier, Map<K, T> backingTxs) {
        this.identifier = Objects.requireNonNull(identifier, "Identifier should not be null");
        this.backingTxs = Objects.requireNonNull(backingTxs, "Backing transactions should not be null");
    }

    protected final T getSubtransaction(K key) {
        Objects.requireNonNull(key, "key must not be null.");
        DOMStoreTransaction ret = (DOMStoreTransaction)this.backingTxs.get(key);
        Preconditions.checkArgument((ret != null ? 1 : 0) != 0, (String)"No subtransaction associated with %s", key);
        return (T)ret;
    }

    protected Collection<T> getSubtransactions() {
        return this.backingTxs.values();
    }

    public Object getIdentifier() {
        return this.identifier;
    }

    protected void closeSubtransactions() {
        Throwable failure = null;
        for (DOMStoreTransaction subtransaction : this.backingTxs.values()) {
            try {
                subtransaction.close();
            }
            catch (Exception e) {
                if (failure == null) {
                    failure = new IllegalStateException("Uncaught exception occured during closing transaction", e);
                    continue;
                }
                failure.addSuppressed(e);
            }
        }
        if (failure != null) {
            throw failure;
        }
    }
}

