/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.dom.broker.AbstractDOMRoutingTableEntry;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;

@Beta
abstract class AbstractDOMRoutingTable<I, D, M, L extends EventListener, K, E extends AbstractDOMRoutingTableEntry<D, M, L, K>> {
    private final Map<K, E> operations;
    private final EffectiveModelContext schemaContext;

    AbstractDOMRoutingTable(Map<K, E> operations, EffectiveModelContext schemaContext) {
        this.operations = Objects.requireNonNull(operations);
        this.schemaContext = schemaContext;
    }

    AbstractDOMRoutingTable<I, D, M, L, K, E> setSchemaContext(EffectiveModelContext context) {
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (Map.Entry<K, E> e : this.operations.entrySet()) {
            E entry = this.createOperationEntry(context, e.getKey(), ((AbstractDOMRoutingTableEntry)e.getValue()).getImplementations());
            if (entry == null) continue;
            b.put(e.getKey(), entry);
        }
        return this.newInstance((Map<K, E>)b.build(), context);
    }

    AbstractDOMRoutingTable<I, D, M, L, K, E> add(M implementation, Set<I> oprsToAdd) {
        if (oprsToAdd.isEmpty()) {
            return this;
        }
        ImmutableMap.Builder mb = ImmutableMap.builder();
        this.add(implementation, oprsToAdd, mb);
        return this.newInstance((Map<K, E>)mb.build(), this.schemaContext);
    }

    private void add(M implementation, Set<I> oprsToAdd, ImmutableMap.Builder<K, E> tableInputBuilder) {
        ListMultimap<K, D> toAdd = this.decomposeIdentifiers(oprsToAdd);
        for (Map.Entry<K, E> entry : this.operations.entrySet()) {
            ArrayList newOperations = new ArrayList(toAdd.removeAll(entry.getKey()));
            if (!newOperations.isEmpty()) {
                AbstractDOMRoutingTableEntry ne = ((AbstractDOMRoutingTableEntry)entry.getValue()).add(implementation, newOperations);
                tableInputBuilder.put(entry.getKey(), ne);
                continue;
            }
            tableInputBuilder.put(entry);
        }
        for (Map.Entry<K, Object> entry : toAdd.asMap().entrySet()) {
            ImmutableMap.Builder vb = ImmutableMap.builder();
            ImmutableList v = ImmutableList.of(implementation);
            for (Object i : (Collection)entry.getValue()) {
                vb.put(i, (Object)v);
            }
            E entry2 = this.createOperationEntry(this.schemaContext, entry.getKey(), (Map<D, List<M>>)vb.build());
            if (entry2 == null) continue;
            tableInputBuilder.put(entry.getKey(), entry2);
        }
    }

    AbstractDOMRoutingTable<I, D, M, L, K, E> addAll(Map<I, M> map) {
        if (map.isEmpty()) {
            return this;
        }
        HashMultimap<M, I> inverted = this.invertImplementationsMap(map);
        ImmutableMap.Builder tableInputBuilder = ImmutableMap.builder();
        for (Object impl : inverted.keySet()) {
            this.add(impl, inverted.get(impl), tableInputBuilder);
        }
        return this.newInstance((Map<K, E>)tableInputBuilder.build(), this.schemaContext);
    }

    AbstractDOMRoutingTable<I, D, M, L, K, E> remove(M implementation, Set<I> instances) {
        if (instances.isEmpty()) {
            return this;
        }
        ListMultimap<K, D> toRemove = this.decomposeIdentifiers(instances);
        ImmutableMap.Builder b = ImmutableMap.builder();
        for (Map.Entry<K, E> e : this.operations.entrySet()) {
            ArrayList removed = new ArrayList(toRemove.removeAll(e.getKey()));
            if (!removed.isEmpty()) {
                AbstractDOMRoutingTableEntry ne = ((AbstractDOMRoutingTableEntry)e.getValue()).remove(implementation, removed);
                if (ne == null) continue;
                b.put(e.getKey(), ne);
                continue;
            }
            b.put(e);
        }
        return this.newInstance((Map<K, E>)b.build(), this.schemaContext);
    }

    private void remove(M implementation, Set<I> oprsToRemove, ImmutableMap.Builder<K, E> tableInputBuilder) {
        ListMultimap<K, D> toRemove = this.decomposeIdentifiers(oprsToRemove);
        for (Map.Entry<K, E> e : this.operations.entrySet()) {
            ArrayList removed = new ArrayList(toRemove.removeAll(e.getKey()));
            if (!removed.isEmpty()) {
                AbstractDOMRoutingTableEntry ne = ((AbstractDOMRoutingTableEntry)e.getValue()).remove(implementation, removed);
                if (ne == null) continue;
                tableInputBuilder.put(e.getKey(), ne);
                continue;
            }
            tableInputBuilder.put(e);
        }
    }

    AbstractDOMRoutingTable<I, D, M, L, K, E> removeAll(Map<I, M> map) {
        if (map.isEmpty()) {
            return this;
        }
        HashMultimap<M, I> inverted = this.invertImplementationsMap(map);
        ImmutableMap.Builder tableInputBuilder = ImmutableMap.builder();
        for (Object impl : inverted.keySet()) {
            this.remove(impl, inverted.get(impl), tableInputBuilder);
        }
        return this.newInstance((Map<K, E>)tableInputBuilder.build(), this.schemaContext);
    }

    HashMultimap<M, I> invertImplementationsMap(Map<I, M> map) {
        return (HashMultimap)Multimaps.invertFrom((Multimap)Multimaps.forMap(map), (Multimap)HashMultimap.create());
    }

    @VisibleForTesting
    Map<K, Set<D>> getOperations() {
        return Maps.transformValues(this.operations, AbstractDOMRoutingTableEntry::registeredIdentifiers);
    }

    Map<K, Set<D>> getOperations(L listener) {
        HashMap ret = new HashMap(this.operations.size());
        for (Map.Entry<K, E> e : this.operations.entrySet()) {
            Set ids = ((AbstractDOMRoutingTableEntry)e.getValue()).registeredIdentifiers(listener);
            if (ids.isEmpty()) continue;
            ret.put(e.getKey(), ids);
        }
        return ret;
    }

    @Nullable AbstractDOMRoutingTableEntry<D, M, L, K> getEntry(@NonNull K type) {
        return (AbstractDOMRoutingTableEntry)this.operations.get(type);
    }

    protected abstract AbstractDOMRoutingTable<I, D, M, L, K, E> newInstance(Map<K, E> var1, EffectiveModelContext var2);

    abstract ListMultimap<K, D> decomposeIdentifiers(Set<I> var1);

    abstract E createOperationEntry(EffectiveModelContext var1, K var2, Map<D, List<M>> var3);
}

