/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opendaylight.mdsal.dom.api.DOMActionAvailabilityExtension;
import org.opendaylight.mdsal.dom.api.DOMActionImplementation;
import org.opendaylight.mdsal.dom.api.DOMActionInstance;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.broker.AbstractDOMRoutingTable;
import org.opendaylight.mdsal.dom.broker.DOMActionRoutingTableEntry;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.ActionNodeContainer;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;

@Beta
final class DOMActionRoutingTable
extends AbstractDOMRoutingTable<DOMActionInstance, DOMDataTreeIdentifier, DOMActionImplementation, DOMActionAvailabilityExtension.AvailabilityListener, SchemaNodeIdentifier.Absolute, DOMActionRoutingTableEntry> {
    static final DOMActionRoutingTable EMPTY = new DOMActionRoutingTable((Map<SchemaNodeIdentifier.Absolute, DOMActionRoutingTableEntry>)ImmutableMap.of(), null);

    private DOMActionRoutingTable(Map<SchemaNodeIdentifier.Absolute, DOMActionRoutingTableEntry> actions, EffectiveModelContext schemaContext) {
        super(actions, schemaContext);
    }

    protected DOMActionRoutingTable newInstance(Map<SchemaNodeIdentifier.Absolute, DOMActionRoutingTableEntry> operations, EffectiveModelContext schemaContext) {
        return new DOMActionRoutingTable(operations, schemaContext);
    }

    @Override
    protected ListMultimap<SchemaNodeIdentifier.Absolute, DOMDataTreeIdentifier> decomposeIdentifiers(Set<DOMActionInstance> instances) {
        LinkedListMultimap ret = LinkedListMultimap.create();
        for (DOMActionInstance instance : instances) {
            instance.getDataTrees().forEach(arg_0 -> DOMActionRoutingTable.lambda$decomposeIdentifiers$0((ListMultimap)ret, instance, arg_0));
        }
        return ret;
    }

    @Override
    protected DOMActionRoutingTableEntry createOperationEntry(EffectiveModelContext context, SchemaNodeIdentifier.Absolute type, Map<DOMDataTreeIdentifier, List<DOMActionImplementation>> implementations) {
        ActionDefinition actionDef = DOMActionRoutingTable.findActionDefinition((SchemaContext)context, type);
        if (actionDef == null) {
            return null;
        }
        return new DOMActionRoutingTableEntry(type, implementations);
    }

    private static ActionDefinition findActionDefinition(SchemaContext context, SchemaNodeIdentifier.Absolute path) {
        SchemaPath legacy = path.asSchemaPath();
        SchemaNode node = SchemaContextUtil.findDataSchemaNode((SchemaContext)context, (SchemaPath)legacy.getParent());
        if (node instanceof ActionNodeContainer) {
            return ((ActionNodeContainer)node).findAction(legacy.getLastComponent()).orElse(null);
        }
        return null;
    }

    private static /* synthetic */ void lambda$decomposeIdentifiers$0(ListMultimap ret, DOMActionInstance instance, DOMDataTreeIdentifier id) {
        ret.put((Object)instance.getType(), (Object)id);
    }
}

