/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.opendaylight.mdsal.dom.api.DOMNotification;
import org.opendaylight.mdsal.dom.api.DOMNotificationListener;
import org.opendaylight.mdsal.dom.api.DOMNotificationPublishService;
import org.opendaylight.mdsal.dom.api.DOMNotificationService;
import org.opendaylight.mdsal.dom.broker.DOMNotificationRouterEvent;
import org.opendaylight.mdsal.dom.spi.DOMNotificationSubscriptionListener;
import org.opendaylight.mdsal.dom.spi.DOMNotificationSubscriptionListenerRegistry;
import org.opendaylight.yangtools.concepts.AbstractListenerRegistration;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.util.ListenerRegistry;
import org.opendaylight.yangtools.util.concurrent.EqualityQueuedNotificationManager;
import org.opendaylight.yangtools.util.concurrent.FluentFutures;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DOMNotificationRouter
implements AutoCloseable,
DOMNotificationPublishService,
DOMNotificationService,
DOMNotificationSubscriptionListenerRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DOMNotificationRouter.class);
    private static final ListenableFuture<Void> NO_LISTENERS = FluentFutures.immediateNullFluentFuture();
    private final ListenerRegistry<DOMNotificationSubscriptionListener> subscriptionListeners = ListenerRegistry.create();
    private final EqualityQueuedNotificationManager<AbstractListenerRegistration<? extends DOMNotificationListener>, DOMNotificationRouterEvent> queueNotificationManager;
    private final ScheduledThreadPoolExecutor observer;
    private final ExecutorService executor;
    private volatile Multimap<SchemaNodeIdentifier.Absolute, AbstractListenerRegistration<? extends DOMNotificationListener>> listeners = ImmutableMultimap.of();

    @VisibleForTesting
    DOMNotificationRouter(int maxQueueCapacity) {
        this.observer = new ScheduledThreadPoolExecutor(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("DOMNotificationRouter-observer-%d").build());
        this.executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("DOMNotificationRouter-listeners-%d").build());
        this.queueNotificationManager = new EqualityQueuedNotificationManager("DOMNotificationRouter", (Executor)this.executor, maxQueueCapacity, DOMNotificationRouter::deliverEvents);
    }

    public static DOMNotificationRouter create(int maxQueueCapacity) {
        return new DOMNotificationRouter(maxQueueCapacity);
    }

    public synchronized <T extends DOMNotificationListener> ListenerRegistration<T> registerNotificationListener(T listener, Collection<SchemaNodeIdentifier.Absolute> types) {
        AbstractListenerRegistration reg = new AbstractListenerRegistration<T>(listener){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void removeRegistration() {
                DOMNotificationRouter dOMNotificationRouter = DOMNotificationRouter.this;
                synchronized (dOMNotificationRouter) {
                    DOMNotificationRouter.this.replaceListeners((Multimap<SchemaNodeIdentifier.Absolute, AbstractListenerRegistration<? extends DOMNotificationListener>>)ImmutableMultimap.copyOf((Multimap)Multimaps.filterValues(DOMNotificationRouter.this.listeners, input -> input != this)));
                }
            }
        };
        if (!types.isEmpty()) {
            ImmutableMultimap.Builder b = ImmutableMultimap.builder();
            b.putAll(this.listeners);
            for (SchemaNodeIdentifier.Absolute t : types) {
                b.put((Object)t, (Object)reg);
            }
            this.replaceListeners((Multimap<SchemaNodeIdentifier.Absolute, AbstractListenerRegistration<? extends DOMNotificationListener>>)b.build());
        }
        return reg;
    }

    private void replaceListeners(Multimap<SchemaNodeIdentifier.Absolute, AbstractListenerRegistration<? extends DOMNotificationListener>> newListeners) {
        this.listeners = newListeners;
        this.notifyListenerTypesChanged(newListeners.keySet());
    }

    private void notifyListenerTypesChanged(Set<SchemaNodeIdentifier.Absolute> typesAfter) {
        List listenersAfter = (List)this.subscriptionListeners.streamListeners().collect(ImmutableList.toImmutableList());
        this.executor.execute(() -> {
            for (DOMNotificationSubscriptionListener subListener : listenersAfter) {
                try {
                    subListener.onSubscriptionChanged(typesAfter);
                }
                catch (Exception e) {
                    LOG.warn("Uncaught exception during invoking listener {}", (Object)subListener, (Object)e);
                }
            }
        });
    }

    public <L extends DOMNotificationSubscriptionListener> ListenerRegistration<L> registerSubscriptionListener(L listener) {
        Set initialTypes = this.listeners.keySet();
        this.executor.execute(() -> listener.onSubscriptionChanged(initialTypes));
        return this.subscriptionListeners.register(listener);
    }

    @VisibleForTesting
    ListenableFuture<? extends Object> publish(DOMNotification notification, Collection<AbstractListenerRegistration<? extends DOMNotificationListener>> subscribers) {
        ArrayList futures = new ArrayList(subscribers.size());
        subscribers.forEach(subscriber -> {
            DOMNotificationRouterEvent event = new DOMNotificationRouterEvent(notification);
            futures.add(event.future());
            this.queueNotificationManager.submitNotification(subscriber, (Object)event);
        });
        return Futures.transform((ListenableFuture)Futures.successfulAsList(futures), ignored -> null, (Executor)MoreExecutors.directExecutor());
    }

    public ListenableFuture<? extends Object> putNotification(DOMNotification notification) throws InterruptedException {
        Collection subscribers = this.listeners.get((Object)notification.getType());
        if (subscribers.isEmpty()) {
            return NO_LISTENERS;
        }
        return this.publish(notification, subscribers);
    }

    public ListenableFuture<? extends Object> offerNotification(DOMNotification notification) {
        Collection subscribers = this.listeners.get((Object)notification.getType());
        if (subscribers.isEmpty()) {
            return NO_LISTENERS;
        }
        return this.publish(notification, subscribers);
    }

    public ListenableFuture<? extends Object> offerNotification(DOMNotification notification, long timeout, TimeUnit unit) throws InterruptedException {
        Collection subscribers = this.listeners.get((Object)notification.getType());
        if (subscribers.isEmpty()) {
            return NO_LISTENERS;
        }
        ListenableFuture<? extends Object> noBlock = this.publish(notification, subscribers);
        if (!DOMNotificationPublishService.REJECTED.equals(noBlock)) {
            return noBlock;
        }
        try {
            Thread publishThread = Thread.currentThread();
            ScheduledFuture<?> timerTask = this.observer.schedule(publishThread::interrupt, timeout, unit);
            ListenableFuture<? extends Object> withBlock = this.putNotification(notification);
            timerTask.cancel(true);
            if (this.observer.getQueue().size() > 50) {
                this.observer.purge();
            }
            return withBlock;
        }
        catch (InterruptedException e) {
            return DOMNotificationPublishService.REJECTED;
        }
    }

    @Override
    public void close() {
        this.observer.shutdown();
        this.executor.shutdown();
    }

    @VisibleForTesting
    ExecutorService executor() {
        return this.executor;
    }

    @VisibleForTesting
    ExecutorService observer() {
        return this.observer;
    }

    @VisibleForTesting
    Multimap<SchemaNodeIdentifier.Absolute, ?> listeners() {
        return this.listeners;
    }

    @VisibleForTesting
    ListenerRegistry<DOMNotificationSubscriptionListener> subscriptionListeners() {
        return this.subscriptionListeners;
    }

    private static void deliverEvents(AbstractListenerRegistration<? extends DOMNotificationListener> reg, ImmutableList<DOMNotificationRouterEvent> events) {
        if (reg.notClosed()) {
            DOMNotificationListener listener = (DOMNotificationListener)reg.getInstance();
            for (DOMNotificationRouterEvent event : events) {
                event.deliverTo(listener);
            }
        } else {
            events.forEach(DOMNotificationRouterEvent::clear);
        }
    }
}

