/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.annotations.Beta;
import org.opendaylight.mdsal.dom.api.DOMActionProviderService;
import org.opendaylight.mdsal.dom.api.DOMActionService;
import org.opendaylight.mdsal.dom.api.DOMRpcProviderService;
import org.opendaylight.mdsal.dom.api.DOMRpcService;
import org.opendaylight.mdsal.dom.api.DOMSchemaService;
import org.opendaylight.mdsal.dom.broker.DOMRpcRouter;
import org.opendaylight.mdsal.dom.broker.DOMRpcRouterServices;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
@Component(immediate=true, service={DOMRpcRouterServices.class})
public final class OSGiDOMRpcRouter
implements DOMRpcRouterServices {
    private static final Logger LOG = LoggerFactory.getLogger(OSGiDOMRpcRouter.class);
    @Reference
    DOMSchemaService schemaService = null;
    private DOMRpcRouter router;

    @Override
    public DOMActionService getActionService() {
        return this.router.getActionService();
    }

    @Override
    public DOMActionProviderService getActionProviderService() {
        return this.router.getActionProviderService();
    }

    @Override
    public DOMRpcService getRpcService() {
        return this.router.getRpcService();
    }

    @Override
    public DOMRpcProviderService getRpcProviderService() {
        return this.router.getRpcProviderService();
    }

    @Activate
    void activate() {
        this.router = DOMRpcRouter.newInstance(this.schemaService);
        LOG.info("DOM RPC/Action router started");
    }

    @Deactivate
    void deactivate() {
        this.router.close();
        this.router = null;
        LOG.info("DOM RPC/Action router stopped");
    }
}

