/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import java.util.concurrent.atomic.AtomicLong;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeService;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMTransactionChain;
import org.opendaylight.mdsal.dom.api.DOMTransactionChainListener;
import org.opendaylight.mdsal.dom.broker.ShardedDOMReadTransactionAdapter;
import org.opendaylight.mdsal.dom.broker.ShardedDOMReadWriteTransactionAdapter;
import org.opendaylight.mdsal.dom.broker.ShardedDOMTransactionChainAdapter;
import org.opendaylight.mdsal.dom.broker.ShardedDOMWriteTransactionAdapter;
import org.opendaylight.mdsal.dom.spi.PingPongMergingDOMDataBroker;

public class ShardedDOMDataBrokerAdapter
implements PingPongMergingDOMDataBroker {
    private final AtomicLong chainNum = new AtomicLong();
    private final AtomicLong txNum = new AtomicLong();
    private final DOMDataTreeService service;

    public ShardedDOMDataBrokerAdapter(DOMDataTreeService service) {
        this.service = service;
    }

    public DOMDataTreeReadTransaction newReadOnlyTransaction() {
        return new ShardedDOMReadTransactionAdapter(this.newTransactionIdentifier(), this.service);
    }

    public DOMDataTreeWriteTransaction newWriteOnlyTransaction() {
        return new ShardedDOMWriteTransactionAdapter(this.newTransactionIdentifier(), this.service);
    }

    public DOMDataTreeReadWriteTransaction newReadWriteTransaction() {
        return new ShardedDOMReadWriteTransactionAdapter(this.newTransactionIdentifier(), this.service);
    }

    public DOMTransactionChain createTransactionChain(DOMTransactionChainListener listener) {
        return new ShardedDOMTransactionChainAdapter(this.newChainIdentifier(), this.service, listener);
    }

    private Object newTransactionIdentifier() {
        return "DOM-" + this.txNum.getAndIncrement();
    }

    private Object newChainIdentifier() {
        return "DOM-CHAIN-" + this.chainNum;
    }
}

