/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeListeningException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeLoopException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.tree.DataTreeCandidate;
import org.opendaylight.yangtools.yang.data.api.schema.tree.ModificationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardedDOMReadTransactionAdapter
implements DOMDataTreeReadTransaction {
    private static final Logger LOG = LoggerFactory.getLogger((String)ShardedDOMReadTransactionAdapter.class.getName());
    private final List<ListenerRegistration<DOMDataTreeListener>> registrations = new ArrayList<ListenerRegistration<DOMDataTreeListener>>();
    private final @NonNull DOMDataTreeService service;
    private final @NonNull Object txIdentifier;
    private boolean finished = false;

    ShardedDOMReadTransactionAdapter(Object identifier, DOMDataTreeService service) {
        this.service = Objects.requireNonNull(service);
        this.txIdentifier = Objects.requireNonNull(identifier);
    }

    public void close() {
        LOG.debug("{}: Closing read transaction", this.txIdentifier);
        if (this.finished) {
            return;
        }
        this.registrations.forEach(ListenerRegistration::close);
        this.finished = true;
    }

    public Object getIdentifier() {
        return this.txIdentifier;
    }

    public FluentFuture<Optional<NormalizedNode<?, ?>>> read(LogicalDatastoreType store, YangInstanceIdentifier path) {
        ListenerRegistration reg;
        this.checkRunning();
        LOG.debug("{}: Invoking read at {}:{}", new Object[]{this.txIdentifier, store, path});
        SettableFuture initialDataTreeChangeFuture = SettableFuture.create();
        try {
            reg = this.service.registerListener((DOMDataTreeListener)new ReadShardedListener(initialDataTreeChangeFuture), Collections.singleton(new DOMDataTreeIdentifier(store, path)), false, Collections.emptyList());
            this.registrations.add((ListenerRegistration<DOMDataTreeListener>)reg);
        }
        catch (DOMDataTreeLoopException e) {
            throw new IllegalStateException("Loop in listener and producers detected", e);
        }
        initialDataTreeChangeFuture.addListener(() -> ((ListenerRegistration)reg).close(), MoreExecutors.directExecutor());
        return FluentFuture.from((ListenableFuture)initialDataTreeChangeFuture);
    }

    public FluentFuture<Boolean> exists(LogicalDatastoreType store, YangInstanceIdentifier path) {
        this.checkRunning();
        LOG.debug("{}: Invoking exists at {}:{}", new Object[]{this.txIdentifier, store, path});
        return this.read(store, path).transform(Optional::isPresent, MoreExecutors.directExecutor());
    }

    private void checkRunning() {
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"Transaction is already closed");
    }

    static final class ReadShardedListener
    implements DOMDataTreeListener {
        private final SettableFuture<Optional<NormalizedNode<?, ?>>> readResultFuture;

        ReadShardedListener(SettableFuture<Optional<NormalizedNode<?, ?>>> future) {
            this.readResultFuture = Objects.requireNonNull(future);
        }

        public void onDataTreeChanged(Collection<DataTreeCandidate> changes, Map<DOMDataTreeIdentifier, NormalizedNode<?, ?>> subtrees) {
            Preconditions.checkState((changes.size() == 1 && subtrees.size() == 1 ? 1 : 0) != 0, (Object)"DOMDataTreeListener registered exactly on one subtree");
            if (changes.iterator().next().getRootNode().getModificationType().equals((Object)ModificationType.UNMODIFIED)) {
                this.readResultFuture.set(Optional.empty());
            } else {
                this.readResultFuture.set(Optional.of(subtrees.values().iterator().next()));
            }
        }

        public void onDataTreeFailed(Collection<DOMDataTreeListeningException> causes) {
            this.readResultFuture.setException((Throwable)new DOMDataTreeListeningException("Aggregated DOMDataTreeListening exception", (Throwable)causes.stream().reduce((e1, e2) -> {
                e1.addSuppressed((Throwable)e2);
                return e1;
            }).get()));
        }
    }
}

