/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.util.concurrent.FluentFuture;
import java.util.Optional;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeReadWriteTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeService;
import org.opendaylight.mdsal.dom.broker.ShardedDOMReadTransactionAdapter;
import org.opendaylight.mdsal.dom.broker.ShardedDOMWriteTransactionAdapter;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

final class ShardedDOMReadWriteTransactionAdapter
extends ShardedDOMWriteTransactionAdapter
implements DOMDataTreeReadWriteTransaction {
    private final ShardedDOMReadTransactionAdapter readAdapter;

    ShardedDOMReadWriteTransactionAdapter(Object identifier, DOMDataTreeService transactionDelegator) {
        super(identifier, transactionDelegator);
        this.readAdapter = new ShardedDOMReadTransactionAdapter(identifier, transactionDelegator);
    }

    public FluentFuture<Optional<NormalizedNode<?, ?>>> read(LogicalDatastoreType store, YangInstanceIdentifier path) {
        return this.readAdapter.read(store, path);
    }

    public FluentFuture<Boolean> exists(LogicalDatastoreType store, YangInstanceIdentifier path) {
        return this.readAdapter.exists(store, path);
    }

    @Override
    public boolean cancel() {
        this.readAdapter.close();
        return super.cancel();
    }

    ShardedDOMReadTransactionAdapter getReadAdapter() {
        return this.readAdapter;
    }
}

