/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.common.api.CommitInfo;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCursor;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCursorAwareTransaction;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.mdsal.dom.api.DOMDataTreeProducer;
import org.opendaylight.mdsal.dom.api.DOMDataTreeProducerException;
import org.opendaylight.mdsal.dom.api.DOMDataTreeService;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteCursor;
import org.opendaylight.mdsal.dom.api.DOMDataTreeWriteTransaction;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardedDOMWriteTransactionAdapter
implements DOMDataTreeWriteTransaction {
    private static final Logger LOG = LoggerFactory.getLogger(ShardedDOMWriteTransactionAdapter.class);
    private final Map<LogicalDatastoreType, DOMDataTreeCursorAwareTransaction> transactionMap = new EnumMap<LogicalDatastoreType, DOMDataTreeCursorAwareTransaction>(LogicalDatastoreType.class);
    private final Map<LogicalDatastoreType, DOMDataTreeWriteCursor> cursorMap = new EnumMap<LogicalDatastoreType, DOMDataTreeWriteCursor>(LogicalDatastoreType.class);
    private final Map<LogicalDatastoreType, DOMDataTreeProducer> producerMap = new EnumMap<LogicalDatastoreType, DOMDataTreeProducer>(LogicalDatastoreType.class);
    private final @NonNull DOMDataTreeService treeService;
    private final @NonNull Object txIdentifier;
    private boolean finished = false;
    private boolean initialized = false;

    ShardedDOMWriteTransactionAdapter(Object identifier, DOMDataTreeService transactionDelegator) {
        this.treeService = Objects.requireNonNull(transactionDelegator);
        this.txIdentifier = Objects.requireNonNull(identifier);
    }

    public boolean cancel() {
        LOG.debug("{}: Cancelling transaction", this.txIdentifier);
        if (this.finished) {
            return false;
        }
        this.cursorMap.values().forEach(DOMDataTreeCursor::close);
        this.transactionMap.values().forEach(domDataTreeCursorAwareTransaction -> Preconditions.checkState((boolean)domDataTreeCursorAwareTransaction.cancel()));
        this.closeProducers();
        this.finished = true;
        return true;
    }

    public @NonNull FluentFuture<? extends @NonNull CommitInfo> commit() {
        this.checkRunning();
        LOG.debug("{}: Submitting transaction", this.txIdentifier);
        if (!this.initialized) {
            this.finished = true;
            return CommitInfo.emptyFluentFuture();
        }
        this.cursorMap.values().forEach(DOMDataTreeCursor::close);
        FluentFuture aggregatedSubmit = FluentFuture.from((ListenableFuture)Futures.allAsList((ListenableFuture[])new ListenableFuture[]{this.transactionMap.get(LogicalDatastoreType.CONFIGURATION).commit(), this.transactionMap.get(LogicalDatastoreType.OPERATIONAL).commit()}));
        this.closeProducers();
        this.finished = true;
        return aggregatedSubmit.transform(unused -> CommitInfo.empty(), MoreExecutors.directExecutor());
    }

    public Object getIdentifier() {
        return this.txIdentifier;
    }

    public void put(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        this.checkRunning();
        LOG.debug("{}: Invoking put operation at {}:{}", new Object[]{this.txIdentifier, store, path});
        LOG.trace("{}: payload is {}", this.txIdentifier, data);
        if (!this.initialized) {
            this.initializeDataTreeProducerLayer(path.getParent());
        }
        DOMDataTreeWriteCursor cursor = this.cursorMap.get(store);
        cursor.write(path.getLastPathArgument(), data);
    }

    public void merge(LogicalDatastoreType store, YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        this.checkRunning();
        LOG.debug("{}: Invoking merge operation at {}:{}", new Object[]{this.txIdentifier, store, path});
        LOG.trace("{}: payload is {}", this.txIdentifier, data);
        if (!this.initialized) {
            this.initializeDataTreeProducerLayer(path.getParent());
        }
        DOMDataTreeWriteCursor cursor = this.cursorMap.get(store);
        cursor.merge(path.getLastPathArgument(), data);
    }

    public void delete(LogicalDatastoreType store, YangInstanceIdentifier path) {
        this.checkRunning();
        LOG.debug("{}: Invoking delete operation at {}:{}", new Object[]{this.txIdentifier, store, path});
        if (!this.initialized) {
            this.initializeDataTreeProducerLayer(path.getParent());
        }
        DOMDataTreeWriteCursor cursor = this.cursorMap.get(store);
        cursor.delete(path.getLastPathArgument());
    }

    private void initializeDataTreeProducerLayer(YangInstanceIdentifier path) {
        Preconditions.checkState((boolean)this.producerMap.isEmpty(), (Object)"Producers already initialized");
        Preconditions.checkState((boolean)this.transactionMap.isEmpty(), (Object)"Transactions already initialized");
        Preconditions.checkState((boolean)this.cursorMap.isEmpty(), (Object)"Cursors already initialized");
        LOG.debug("{}: Creating data tree producers on path {}", this.txIdentifier, (Object)path);
        this.producerMap.put(LogicalDatastoreType.CONFIGURATION, this.treeService.createProducer(Collections.singleton(new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, path))));
        this.producerMap.put(LogicalDatastoreType.OPERATIONAL, this.treeService.createProducer(Collections.singleton(new DOMDataTreeIdentifier(LogicalDatastoreType.OPERATIONAL, path))));
        LOG.debug("{}: Creating DOMDataTreeCursorAwareTransactions delegates on {}", this.txIdentifier, (Object)path);
        this.transactionMap.put(LogicalDatastoreType.CONFIGURATION, this.producerMap.get(LogicalDatastoreType.CONFIGURATION).createTransaction(true));
        this.transactionMap.put(LogicalDatastoreType.OPERATIONAL, this.producerMap.get(LogicalDatastoreType.OPERATIONAL).createTransaction(true));
        LOG.debug("{}: Creating DOMDataTreeWriteCursors delegates", this.txIdentifier);
        this.cursorMap.put(LogicalDatastoreType.CONFIGURATION, this.transactionMap.get(LogicalDatastoreType.CONFIGURATION).createCursor(new DOMDataTreeIdentifier(LogicalDatastoreType.CONFIGURATION, path)));
        this.cursorMap.put(LogicalDatastoreType.OPERATIONAL, this.transactionMap.get(LogicalDatastoreType.OPERATIONAL).createCursor(new DOMDataTreeIdentifier(LogicalDatastoreType.OPERATIONAL, path)));
        this.initialized = true;
    }

    private void checkRunning() {
        Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"{}: Transaction already finished");
    }

    private void closeProducers() {
        this.producerMap.values().forEach(domDataTreeProducer -> {
            try {
                domDataTreeProducer.close();
            }
            catch (DOMDataTreeProducerException e) {
                throw new IllegalStateException("Trying to close DOMDataTreeProducer with open transaction", e);
            }
        });
    }
}

