/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.dom.broker.schema;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Optional;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.opendaylight.mdsal.dom.spi.AbstractDOMSchemaService;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.util.ListenerRegistry;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContextListener;
import org.opendaylight.yangtools.yang.model.parser.api.YangSyntaxErrorException;
import org.opendaylight.yangtools.yang.model.repo.api.SchemaSourceException;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.YangTextSchemaSource;
import org.opendaylight.yangtools.yang.parser.repo.YangTextSchemaContextResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ScanningSchemaServiceProvider
extends AbstractDOMSchemaService.WithYangTextSources
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ScanningSchemaServiceProvider.class);
    private final YangTextSchemaContextResolver contextResolver = YangTextSchemaContextResolver.create((String)"global-bundle");
    private final @GuardedBy(value={"lock"}) ListenerRegistry<EffectiveModelContextListener> listeners = ListenerRegistry.create();
    private final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryToUpdateSchemaContext() {
        Object object = this.lock;
        synchronized (object) {
            Optional optSchema = this.contextResolver.getEffectiveModelContext();
            optSchema.ifPresent(schema -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Got new SchemaContext: # of modules {}", (Object)schema.getModules().size());
                }
                this.notifyListeners((EffectiveModelContext)schema);
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void notifyListeners(EffectiveModelContext schemaContext) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.streamListeners().forEach(listener -> {
                try {
                    listener.onModelContextUpdated(schemaContext);
                }
                catch (Exception e) {
                    LOG.error("Exception occured during invoking listener {}", listener, (Object)e);
                }
            });
        }
    }

    public List<Registration> registerAvailableYangs(List<URL> yangs) {
        ArrayList<Registration> sourceRegistrator = new ArrayList<Registration>();
        for (URL url : yangs) {
            try {
                sourceRegistrator.add((Registration)this.contextResolver.registerSource(url));
            }
            catch (IOException | YangSyntaxErrorException | SchemaSourceException e) {
                LOG.warn("Failed to register {}, ignoring it", (Object)url, (Object)e);
            }
        }
        return sourceRegistrator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListeners() {
        Object object = this.lock;
        synchronized (object) {
            return !this.listeners.isEmpty();
        }
    }

    public EffectiveModelContext getGlobalContext() {
        return this.contextResolver.getEffectiveModelContext().orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenerRegistration<EffectiveModelContextListener> registerSchemaContextListener(EffectiveModelContextListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.contextResolver.getEffectiveModelContext().ifPresent(arg_0 -> ((EffectiveModelContextListener)listener).onModelContextUpdated(arg_0));
            return this.listeners.register((EventListener)listener);
        }
    }

    public ListenableFuture<? extends YangTextSchemaSource> getSource(SourceIdentifier sourceIdentifier) {
        return this.contextResolver.getSource(sourceIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.clear();
        }
    }
}

