/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TpId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.link.attributes.Source;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class SourceBuilder
implements Builder<Source> {
    private NodeId _sourceNode;
    private TpId _sourceTp;
    Map<Class<? extends Augmentation<Source>>, Augmentation<Source>> augmentation = Collections.emptyMap();

    public SourceBuilder() {
    }

    public SourceBuilder(Source base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Source>>, Augmentation<Source>>(aug);
        }
        this._sourceNode = base.getSourceNode();
        this._sourceTp = base.getSourceTp();
    }

    public NodeId getSourceNode() {
        return this._sourceNode;
    }

    public TpId getSourceTp() {
        return this._sourceTp;
    }

    public <E$$ extends Augmentation<Source>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public SourceBuilder setSourceNode(NodeId value) {
        this._sourceNode = value;
        return this;
    }

    public SourceBuilder setSourceTp(TpId value) {
        this._sourceTp = value;
        return this;
    }

    public SourceBuilder addAugmentation(Augmentation<Source> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Source>>, Augmentation<Source>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public SourceBuilder removeAugmentation(Class<? extends Augmentation<Source>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Source build() {
        return new SourceImpl(this);
    }

    private static final class SourceImpl
    extends AbstractAugmentable<Source>
    implements Source {
        private final NodeId _sourceNode;
        private final TpId _sourceTp;
        private int hash = 0;
        private volatile boolean hashValid = false;

        SourceImpl(SourceBuilder base) {
            super(base.augmentation);
            this._sourceNode = base.getSourceNode();
            this._sourceTp = base.getSourceTp();
        }

        @Override
        public NodeId getSourceNode() {
            return this._sourceNode;
        }

        @Override
        public TpId getSourceTp() {
            return this._sourceTp;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Source.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Source.bindingEquals(this, obj);
        }

        public String toString() {
            return Source.bindingToString(this);
        }
    }
}

