/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeAttributes;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.node.TerminationPoint;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.node.TerminationPointKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.node.attributes.SupportingNode;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.node.attributes.SupportingNodeKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NodeBuilder
implements Builder<Node> {
    private NodeId _nodeId;
    private Map<SupportingNodeKey, SupportingNode> _supportingNode;
    private Map<TerminationPointKey, TerminationPoint> _terminationPoint;
    private NodeKey key;
    Map<Class<? extends Augmentation<Node>>, Augmentation<Node>> augmentation = Collections.emptyMap();

    public NodeBuilder() {
    }

    public NodeBuilder(NodeAttributes arg) {
        this._nodeId = arg.getNodeId();
        this._supportingNode = arg.getSupportingNode();
    }

    public NodeBuilder(Node base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Node>>, Augmentation<Node>>(aug);
        }
        this.key = base.key();
        this._nodeId = base.getNodeId();
        this._supportingNode = base.getSupportingNode();
        this._terminationPoint = base.getTerminationPoint();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NodeAttributes) {
            this._nodeId = ((NodeAttributes)arg).getNodeId();
            this._supportingNode = ((NodeAttributes)arg).getSupportingNode();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeAttributes]");
    }

    public NodeKey key() {
        return this.key;
    }

    public NodeId getNodeId() {
        return this._nodeId;
    }

    public Map<SupportingNodeKey, SupportingNode> getSupportingNode() {
        return this._supportingNode;
    }

    public Map<TerminationPointKey, TerminationPoint> getTerminationPoint() {
        return this._terminationPoint;
    }

    public <E$$ extends Augmentation<Node>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public NodeBuilder withKey(NodeKey key) {
        this.key = key;
        return this;
    }

    public NodeBuilder setNodeId(NodeId value) {
        this._nodeId = value;
        return this;
    }

    public NodeBuilder setSupportingNode(Map<SupportingNodeKey, SupportingNode> values) {
        this._supportingNode = values;
        return this;
    }

    @Deprecated(forRemoval=true)
    public NodeBuilder setSupportingNode(List<SupportingNode> values) {
        return this.setSupportingNode(CodeHelpers.compatMap(values));
    }

    public NodeBuilder setTerminationPoint(Map<TerminationPointKey, TerminationPoint> values) {
        this._terminationPoint = values;
        return this;
    }

    @Deprecated(forRemoval=true)
    public NodeBuilder setTerminationPoint(List<TerminationPoint> values) {
        return this.setTerminationPoint(CodeHelpers.compatMap(values));
    }

    public NodeBuilder addAugmentation(Augmentation<Node> augmentation) {
        Class augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Node>>, Augmentation<Node>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NodeBuilder removeAugmentation(Class<? extends Augmentation<Node>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Node build() {
        return new NodeImpl(this);
    }

    private static final class NodeImpl
    extends AbstractAugmentable<Node>
    implements Node {
        private final NodeId _nodeId;
        private final Map<SupportingNodeKey, SupportingNode> _supportingNode;
        private final Map<TerminationPointKey, TerminationPoint> _terminationPoint;
        private final NodeKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        NodeImpl(NodeBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new NodeKey(base.getNodeId());
            this._nodeId = this.key.getNodeId();
            this._supportingNode = CodeHelpers.emptyToNull(base.getSupportingNode());
            this._terminationPoint = CodeHelpers.emptyToNull(base.getTerminationPoint());
        }

        @Override
        public NodeKey key() {
            return this.key;
        }

        @Override
        public NodeId getNodeId() {
            return this._nodeId;
        }

        @Override
        public Map<SupportingNodeKey, SupportingNode> getSupportingNode() {
            return this._supportingNode;
        }

        @Override
        public Map<TerminationPointKey, TerminationPoint> getTerminationPoint() {
            return this._terminationPoint;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Node.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Node.bindingEquals(this, obj);
        }

        public String toString() {
            return Node.bindingToString(this);
        }
    }
}

