/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.eos.common.api;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.eos.common.api.EntityOwnershipChangeState;
import org.opendaylight.mdsal.eos.common.api.GenericEntity;
import org.opendaylight.yangtools.concepts.Path;

public class GenericEntityOwnershipChange<P extends Path<P>, E extends GenericEntity<P>> {
    private final @NonNull E entity;
    private final @NonNull EntityOwnershipChangeState state;
    private final boolean inJeopardy;

    public GenericEntityOwnershipChange(@NonNull E entity, @NonNull EntityOwnershipChangeState state) {
        this(entity, state, false);
    }

    public GenericEntityOwnershipChange(@NonNull E entity, @NonNull EntityOwnershipChangeState state, boolean inJeopardy) {
        this.entity = (GenericEntity)Objects.requireNonNull(entity, "entity can't be null");
        this.state = Objects.requireNonNull(state, "state can't be null");
        this.inJeopardy = inJeopardy;
    }

    public @NonNull E getEntity() {
        return this.entity;
    }

    public @NonNull EntityOwnershipChangeState getState() {
        return this.state;
    }

    public boolean inJeopardy() {
        return this.inJeopardy;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [entity=" + this.entity + ", state=" + this.state + ", inJeopardy=" + this.inJeopardy + "]";
    }
}

