/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.cluster.datastore.node.utils.transformer;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import javax.xml.transform.dom.DOMSource;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.ReusableImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextNode;
import org.opendaylight.yangtools.yang.data.util.DataSchemaContextTree;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractNormalizedNodePruner
implements NormalizedNodeStreamWriter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNormalizedNodePruner.class);
    private final Deque<DataSchemaContextNode<?>> stack = new ArrayDeque();
    private final ReusableImmutableNormalizedNodeStreamWriter delegate = ReusableImmutableNormalizedNodeStreamWriter.create();
    private final DataSchemaContextTree tree;
    private DataSchemaContextNode<?> nodePathSchemaNode;
    private NormalizedNode<?, ?> normalizedNode;
    private State state = State.UNITIALIZED;
    private int unknown;

    AbstractNormalizedNodePruner(DataSchemaContextTree tree) {
        this.tree = Objects.requireNonNull(tree);
    }

    AbstractNormalizedNodePruner(EffectiveModelContext schemaContext) {
        this(DataSchemaContextTree.from((EffectiveModelContext)schemaContext));
    }

    final DataSchemaContextTree getTree() {
        return this.tree;
    }

    final void initialize(YangInstanceIdentifier nodePath) {
        this.nodePathSchemaNode = this.tree.findChild(nodePath).orElse(null);
        this.unknown = 0;
        this.normalizedNode = null;
        this.stack.clear();
        this.delegate.reset();
        this.state = State.OPEN;
    }

    public final void startLeafNode(YangInstanceIdentifier.NodeIdentifier name) throws IOException {
        this.enter(ImmutableNormalizedNodeStreamWriter::startLeafNode, name);
    }

    public final void startLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.enter(ImmutableNormalizedNodeStreamWriter::startLeafSet, name, childSizeHint);
    }

    public final void startOrderedLeafSet(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.enter(ImmutableNormalizedNodeStreamWriter::startOrderedLeafSet, name, childSizeHint);
    }

    public void startLeafSetEntryNode(YangInstanceIdentifier.NodeWithValue<?> name) throws IOException {
        this.enter((WriterMethod)ImmutableNormalizedNodeStreamWriter::startLeafSetEntryNode, (YangInstanceIdentifier.PathArgument)name);
    }

    public final void startContainerNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.enter(ImmutableNormalizedNodeStreamWriter::startContainerNode, name, childSizeHint);
    }

    public final void startYangModeledAnyXmlNode(YangInstanceIdentifier.NodeIdentifier nodeIdentifier, int count) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public final void startUnkeyedList(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.enter(ImmutableNormalizedNodeStreamWriter::startUnkeyedList, name, childSizeHint);
    }

    public final void startUnkeyedListItem(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.enter(ImmutableNormalizedNodeStreamWriter::startUnkeyedListItem, name, childSizeHint);
    }

    public final void startMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.enter(ImmutableNormalizedNodeStreamWriter::startMapNode, name, childSizeHint);
    }

    public void startMapEntryNode(YangInstanceIdentifier.NodeIdentifierWithPredicates identifier, int childSizeHint) throws IOException {
        this.enter(ImmutableNormalizedNodeStreamWriter::startMapEntryNode, identifier, childSizeHint);
    }

    public final void startOrderedMapNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.enter(ImmutableNormalizedNodeStreamWriter::startOrderedMapNode, name, childSizeHint);
    }

    public final void startChoiceNode(YangInstanceIdentifier.NodeIdentifier name, int childSizeHint) throws IOException {
        this.enter(ImmutableNormalizedNodeStreamWriter::startChoiceNode, name, childSizeHint);
    }

    public final void startAugmentationNode(YangInstanceIdentifier.AugmentationIdentifier identifier) throws IOException {
        this.enter(ImmutableNormalizedNodeStreamWriter::startAugmentationNode, identifier);
    }

    public final boolean startAnyxmlNode(YangInstanceIdentifier.NodeIdentifier name, Class<?> objectModel) throws IOException {
        if (this.enter((YangInstanceIdentifier.PathArgument)name)) {
            Verify.verify((boolean)this.delegate.startAnyxmlNode(name, objectModel), (String)"Unexpected failure to stream DOMSource node %s model %s", (Object)name, objectModel);
        }
        return true;
    }

    public final boolean startAnydataNode(YangInstanceIdentifier.NodeIdentifier name, Class<?> objectModel) throws IOException {
        return false;
    }

    public final void domSourceValue(DOMSource value) throws IOException {
        this.checkNotSealed();
        if (this.unknown == 0) {
            this.delegate.domSourceValue(value);
        }
    }

    public final void scalarValue(Object value) throws IOException {
        this.checkNotSealed();
        if (this.unknown == 0) {
            this.delegate.scalarValue(this.translateScalar(this.currentSchema(), value));
        }
    }

    Object translateScalar(DataSchemaContextNode<?> context, Object value) throws IOException {
        return value;
    }

    public final void endNode() throws IOException {
        this.checkNotSealed();
        if (this.unknown == 0) {
            try {
                this.stack.pop();
            }
            catch (NoSuchElementException e) {
                throw new IllegalStateException("endNode called on an empty stack", e);
            }
            this.delegate.endNode();
        } else {
            --this.unknown;
            if (this.unknown != 0) {
                return;
            }
        }
        if (this.stack.isEmpty()) {
            this.normalizedNode = this.delegate.getResult();
            this.state = State.CLOSED;
        }
    }

    public final void close() throws IOException {
        this.state = State.CLOSED;
        this.stack.clear();
        this.delegate.close();
    }

    public final void flush() throws IOException {
        this.delegate.flush();
    }

    public final Optional<NormalizedNode<?, ?>> getResult() {
        Preconditions.checkState((this.state == State.CLOSED ? 1 : 0) != 0, (String)"Cannot get result in state %s", (Object)((Object)this.state));
        return Optional.ofNullable(this.normalizedNode);
    }

    private void checkNotSealed() {
        Preconditions.checkState((this.state == State.OPEN ? 1 : 0) != 0, (String)"Illegal operation in state %s", (Object)((Object)this.state));
    }

    private boolean enter(YangInstanceIdentifier.PathArgument name) {
        this.checkNotSealed();
        if (this.unknown != 0) {
            LOG.debug("Skipping child {} in unknown subtree", (Object)name);
            ++this.unknown;
            return false;
        }
        DataSchemaContextNode<?> parent = this.currentSchema();
        DataSchemaContextNode schema = parent != null ? parent.getChild(name) : this.nodePathSchemaNode;
        if (schema == null) {
            LOG.debug("Schema not found for {}", (Object)name);
            this.unknown = 1;
            return false;
        }
        this.stack.push(schema);
        DataSchemaNode dataSchema = schema.getDataSchemaNode();
        if (dataSchema != null) {
            this.delegate.nextDataSchemaNode(dataSchema);
        }
        return true;
    }

    final <A extends YangInstanceIdentifier.PathArgument> void enter(WriterMethod<A> method, A name) throws IOException {
        if (this.enter(name)) {
            method.apply(this.delegate, name);
        }
    }

    final <A extends YangInstanceIdentifier.PathArgument> void enter(SizedWriterMethod<A> method, A name, int size) throws IOException {
        if (this.enter(name)) {
            method.apply(this.delegate, name, size);
        }
    }

    final DataSchemaContextNode<?> currentSchema() {
        return this.stack.peek();
    }

    @FunctionalInterface
    static interface SizedWriterMethod<T extends YangInstanceIdentifier.PathArgument> {
        public void apply(ReusableImmutableNormalizedNodeStreamWriter var1, T var2, int var3) throws IOException;
    }

    @FunctionalInterface
    static interface WriterMethod<T extends YangInstanceIdentifier.PathArgument> {
        public void apply(ReusableImmutableNormalizedNodeStreamWriter var1, T var2) throws IOException;
    }

    static enum State {
        UNITIALIZED,
        OPEN,
        CLOSED;

    }
}

