/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.concepts;

import com.google.common.annotations.Beta;
import com.google.common.base.Verify;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.opendaylight.yangtools.concepts.Codec;

@Beta
@NonNullByDefault
public abstract class AbstractCodec<P, I, X extends Exception>
implements Codec<P, I, X> {
    @Override
    public final @NonNull I deserialize(@NonNull P input) throws X {
        return (I)Verify.verifyNotNull(this.deserializeImpl(Objects.requireNonNull(input)), (String)"Codec %s returned null on %s", (Object[])new Object[]{this, input});
    }

    @Override
    public final @NonNull P serialize(@NonNull I input) throws X {
        return (P)Verify.verifyNotNull(this.serializeImpl(Objects.requireNonNull(input)), (String)"Codec %s returned null on %s", (Object[])new Object[]{this, input});
    }

    protected abstract @NonNull I deserializeImpl(@NonNull P var1) throws X;

    protected abstract @NonNull P serializeImpl(@NonNull I var1) throws X;
}

