/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.concepts;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.concepts.Immutable;

@Beta
@NonNullByDefault
public class Variant<T, U>
implements Immutable {
    private final @Nullable T first;
    private final @Nullable U second;

    @SuppressFBWarnings(value={"NP_STORE_INTO_NONNULL_FIELD"})
    protected Variant(T first) {
        this.first = Objects.requireNonNull(first);
        this.second = null;
    }

    @SuppressFBWarnings(value={"NP_STORE_INTO_NONNULL_FIELD"})
    protected Variant(U second, @Nullable Void dummy) {
        this.first = null;
        this.second = Objects.requireNonNull(second);
    }

    protected final T first() {
        return (T)Verify.verifyNotNull(this.first);
    }

    protected final U second() {
        return (U)Verify.verifyNotNull(this.second);
    }

    public static <T, U> Variant<T, U> ofFirst(T value) {
        return new Variant<T, U>(value);
    }

    public static <T, U> Variant<T, U> ofSecond(U value) {
        return new Variant<T, U>(value, null);
    }

    public final boolean isFirst() {
        return this.first != null;
    }

    public final T getFirst() {
        return this.tryFirst().get();
    }

    public final Optional<T> tryFirst() {
        return Optional.ofNullable(this.first);
    }

    public final boolean isSecond() {
        return this.second != null;
    }

    public final U getSecond() {
        return this.trySecond().get();
    }

    public final Optional<U> trySecond() {
        return Optional.ofNullable(this.second);
    }

    public final int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    public final boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        Variant other = (Variant)obj;
        return Objects.equals(this.first, other.first) && Objects.equals(this.second, other.second);
    }

    public final String toString() {
        return this.addToString(MoreObjects.toStringHelper((Object)this).omitNullValues()).toString();
    }

    protected MoreObjects.ToStringHelper addToString(MoreObjects.ToStringHelper helper) {
        return helper.add("first", this.first).add("second", this.second);
    }
}

