/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.rfc8528.parser;

import com.google.common.collect.ImmutableList;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.rfc8528.model.api.MountPointEffectiveStatement;
import org.opendaylight.yangtools.rfc8528.model.api.MountPointSchemaNode;
import org.opendaylight.yangtools.rfc8528.model.api.MountPointStatement;
import org.opendaylight.yangtools.rfc8528.model.api.SchemaMountStatements;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.YangStmtMapping;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.model.api.stmt.UnknownStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractDeclaredStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseQNameStatementSupport;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.UnknownEffectiveStatementBase;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

public final class MountPointStatementSupport
extends BaseQNameStatementSupport<MountPointStatement, MountPointEffectiveStatement> {
    private static final MountPointStatementSupport INSTANCE = new MountPointStatementSupport((StatementDefinition)SchemaMountStatements.MOUNT_POINT);
    private final SubstatementValidator validator;

    MountPointStatementSupport(StatementDefinition definition) {
        super(definition);
        this.validator = SubstatementValidator.builder((StatementDefinition)definition).addOptional((StatementDefinition)YangStmtMapping.CONFIG).addOptional((StatementDefinition)YangStmtMapping.DESCRIPTION).addOptional((StatementDefinition)YangStmtMapping.REFERENCE).addOptional((StatementDefinition)YangStmtMapping.STATUS).build();
    }

    public static MountPointStatementSupport getInstance() {
        return INSTANCE;
    }

    public QName parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return StmtContextUtils.parseIdentifier(ctx, (String)value);
    }

    public QName adaptArgumentValue(StmtContext<QName, MountPointStatement, MountPointEffectiveStatement> ctx, QNameModule targetModule) {
        return ((QName)ctx.coerceStatementArgument()).bindTo(targetModule).intern();
    }

    public void onStatementAdded(StmtContext.Mutable<QName, MountPointStatement, MountPointEffectiveStatement> stmt) {
        StatementDefinition parentDef = stmt.coerceParentContext().getPublicDefinition();
        SourceException.throwIf((YangStmtMapping.CONTAINER != parentDef && YangStmtMapping.LIST != parentDef ? 1 : 0) != 0, (StatementSourceReference)stmt.getStatementSourceReference(), (String)"Mount points may only be defined at either a container or a list", (Object[])new Object[0]);
    }

    protected SubstatementValidator getSubstatementValidator() {
        return this.validator;
    }

    protected MountPointStatement createDeclared(@NonNull StmtContext<QName, MountPointStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new Declared((QName)ctx.coerceStatementArgument(), substatements);
    }

    protected MountPointStatement createEmptyDeclared(StmtContext<QName, MountPointStatement, ?> ctx) {
        return this.createDeclared(ctx, (ImmutableList<? extends DeclaredStatement<?>>)ImmutableList.of());
    }

    protected MountPointEffectiveStatement createEffective(StmtContext<QName, MountPointStatement, MountPointEffectiveStatement> ctx, MountPointStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new Effective(declared, substatements, ctx);
    }

    protected MountPointEffectiveStatement createEmptyEffective(StmtContext<QName, MountPointStatement, MountPointEffectiveStatement> ctx, MountPointStatement declared) {
        return this.createEffective(ctx, declared, ImmutableList.of());
    }

    private static final class Effective
    extends UnknownEffectiveStatementBase<QName, MountPointStatement>
    implements MountPointEffectiveStatement,
    MountPointSchemaNode {
        private final @NonNull SchemaPath path;

        Effective(MountPointStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements, StmtContext<QName, MountPointStatement, ?> ctx) {
            super((Object)((QName)ctx.coerceStatementArgument()), (UnknownStatement)declared, substatements, ctx);
            this.path = ((SchemaPath)ctx.coerceParentContext().getSchemaPath().get()).createChild((QName)this.argument());
        }

        public QName getQName() {
            return this.path.getLastComponent();
        }

        @Deprecated
        public SchemaPath getPath() {
            return this.path;
        }

        public MountPointEffectiveStatement asEffectiveStatement() {
            return this;
        }
    }

    private static final class Declared
    extends AbstractDeclaredStatement.WithQNameArgument.WithSubstatements
    implements MountPointStatement {
        Declared(QName argument, ImmutableList<? extends DeclaredStatement<?>> substatements) {
            super(argument, substatements);
        }
    }
}

