/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.runtime.api;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.model.api.DefaultType;
import org.opendaylight.mdsal.binding.model.api.GeneratedType;
import org.opendaylight.mdsal.binding.model.api.MethodSignature;
import org.opendaylight.mdsal.binding.model.api.ParameterizedType;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.mdsal.binding.model.api.type.builder.GeneratedTypeBuilder;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeTypes;
import org.opendaylight.yangtools.yang.binding.Action;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.util.EffectiveAugmentationSchema;
import org.opendaylight.yangtools.yang.model.util.SchemaNodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class AbstractBindingRuntimeContext
implements BindingRuntimeContext {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBindingRuntimeContext.class);
    private final LoadingCache<QName, Class<?>> identityClasses = CacheBuilder.newBuilder().weakValues().build(new CacheLoader<QName, Class<?>>(){

        public Class<?> load(QName key) {
            Optional<Type> identityType = AbstractBindingRuntimeContext.this.getTypes().findIdentity(key);
            Preconditions.checkArgument((boolean)identityType.isPresent(), (String)"Supplied QName %s is not a valid identity", (Object)key);
            try {
                return AbstractBindingRuntimeContext.this.loadClass(identityType.get());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Required class " + identityType + "was not found.", e);
            }
        }
    });

    @Override
    public final <T extends Augmentation<?>> AugmentationSchemaNode getAugmentationDefinition(Class<T> augClass) {
        return this.getTypes().findAugmentation(DefaultType.of(augClass)).orElse(null);
    }

    @Override
    public final DataSchemaNode getSchemaDefinition(Class<?> cls) {
        Preconditions.checkArgument((!Augmentation.class.isAssignableFrom(cls) ? 1 : 0) != 0, (String)"Supplied class must not be an augmentation (%s is)", cls);
        Preconditions.checkArgument((!Action.class.isAssignableFrom(cls) ? 1 : 0) != 0, (String)"Supplied class must not be an action (%s is)", cls);
        return this.getTypes().findSchema(DefaultType.of(cls)).orElse(null);
    }

    @Override
    public final ActionDefinition getActionDefinition(Class<? extends Action<?, ?, ?>> cls) {
        return this.getTypes().findSchema(DefaultType.of(cls)).orElse(null);
    }

    @Override
    public final SchemaNodeIdentifier.Absolute getActionIdentifier(Class<? extends Action<?, ?, ?>> cls) {
        return this.getTypes().findSchemaNodeIdentifier(DefaultType.of(cls)).orElse(null);
    }

    @Override
    public final Map.Entry<YangInstanceIdentifier.AugmentationIdentifier, AugmentationSchemaNode> getResolvedAugmentationSchema(DataNodeContainer target, Class<? extends Augmentation<?>> aug) {
        AugmentationSchemaNode origSchema = this.getAugmentationDefinition(aug);
        Preconditions.checkArgument((origSchema != null ? 1 : 0) != 0, (String)"Augmentation %s is not known in current schema context", aug);
        HashSet<QName> childNames = new HashSet<QName>();
        HashSet<DataSchemaNode> realChilds = new HashSet<DataSchemaNode>();
        for (DataSchemaNode child : origSchema.getChildNodes()) {
            DataSchemaNode dataChildQNname = target.dataChildByName(child.getQName());
            String childLocalName = child.getQName().getLocalName();
            if (dataChildQNname == null) {
                for (DataSchemaNode dataSchemaNode : target.getChildNodes()) {
                    if (!childLocalName.equals(dataSchemaNode.getQName().getLocalName())) continue;
                    realChilds.add(dataSchemaNode);
                    childNames.add(dataSchemaNode.getQName());
                }
                continue;
            }
            realChilds.add(dataChildQNname);
            childNames.add(child.getQName());
        }
        YangInstanceIdentifier.AugmentationIdentifier identifier = YangInstanceIdentifier.AugmentationIdentifier.create(childNames);
        EffectiveAugmentationSchema proxy = new EffectiveAugmentationSchema(origSchema, realChilds);
        return new AbstractMap.SimpleEntry<YangInstanceIdentifier.AugmentationIdentifier, EffectiveAugmentationSchema>(identifier, proxy);
    }

    @Override
    public final Optional<CaseSchemaNode> getCaseSchemaDefinition(ChoiceSchemaNode schema, Class<?> childClass) {
        DataSchemaNode origSchema = this.getSchemaDefinition(childClass);
        Preconditions.checkArgument((boolean)(origSchema instanceof CaseSchemaNode), (String)"Supplied schema %s is not case.", (Object)origSchema);
        return AbstractBindingRuntimeContext.findInstantiatedCase(schema, (CaseSchemaNode)origSchema);
    }

    @Override
    public final Map.Entry<GeneratedType, DocumentedNode.WithStatus> getTypeWithSchema(Class<?> type) {
        return AbstractBindingRuntimeContext.getTypeWithSchema(this.getTypes(), DefaultType.of(type));
    }

    private static @NonNull Map.Entry<GeneratedType, // Could not load outer class - annotation placement on inner may be incorrect
    DocumentedNode.WithStatus> getTypeWithSchema(BindingRuntimeTypes types, Type referencedType) {
        DocumentedNode.WithStatus schema = types.findSchema(referencedType).orElseThrow(() -> new NullPointerException("Failed to find schema for type " + referencedType));
        Type definedType = types.findType(schema).orElseThrow(() -> new NullPointerException("Failed to find defined type for " + referencedType + " schema " + schema));
        if (definedType instanceof GeneratedTypeBuilder) {
            return new AbstractMap.SimpleEntry<GeneratedType, DocumentedNode.WithStatus>(((GeneratedTypeBuilder)definedType).build(), schema);
        }
        Preconditions.checkArgument((boolean)(definedType instanceof GeneratedType), (String)"Type %s is not a GeneratedType", (Object)referencedType);
        return new AbstractMap.SimpleEntry<GeneratedType, DocumentedNode.WithStatus>((GeneratedType)definedType, schema);
    }

    @Override
    public final Map<Type, Map.Entry<Type, Type>> getChoiceCaseChildren(DataNodeContainer schema) {
        return AbstractBindingRuntimeContext.getChoiceCaseChildren(this.getTypes(), schema);
    }

    private static @NonNull ImmutableMap<Type, Map.Entry<Type, Type>> getChoiceCaseChildren(BindingRuntimeTypes types, DataNodeContainer schema) {
        HashMap<Type, AbstractMap.SimpleEntry<Type, Type>> childToCase = new HashMap<Type, AbstractMap.SimpleEntry<Type, Type>>();
        for (ChoiceSchemaNode choice : Iterables.filter((Iterable)schema.getChildNodes(), ChoiceSchemaNode.class)) {
            ChoiceSchemaNode originalChoice = AbstractBindingRuntimeContext.getOriginalSchema(choice);
            Optional<Type> optType = types.findType((DocumentedNode.WithStatus)originalChoice);
            Preconditions.checkState((boolean)optType.isPresent(), (String)"Failed to find generated type for choice %s", (Object)originalChoice);
            Type choiceType = optType.get();
            for (Type caze : types.findCases(choiceType)) {
                AbstractMap.SimpleEntry<Type, Type> caseIdentifier = new AbstractMap.SimpleEntry<Type, Type>(choiceType, caze);
                HashSet<Type> caseChildren = new HashSet<Type>();
                if (caze instanceof GeneratedTypeBuilder) {
                    caze = ((GeneratedTypeBuilder)caze).build();
                }
                AbstractBindingRuntimeContext.collectAllContainerTypes((GeneratedType)caze, caseChildren);
                for (Type caseChild : caseChildren) {
                    childToCase.put(caseChild, caseIdentifier);
                }
            }
        }
        return ImmutableMap.copyOf(childToCase);
    }

    @Override
    public final Set<Class<?>> getCases(Class<?> choice) {
        Collection<Type> cazes = this.getTypes().findCases(DefaultType.of(choice));
        HashSet ret = new HashSet(cazes.size());
        for (Type caze : cazes) {
            try {
                ret.add(this.loadClass(caze));
            }
            catch (ClassNotFoundException e) {
                LOG.warn("Failed to load class for case {}, ignoring it", (Object)caze, (Object)e);
            }
        }
        return ret;
    }

    @Override
    public final Class<?> getClassForSchema(SchemaNode childSchema) {
        SchemaNode origSchema = AbstractBindingRuntimeContext.getOriginalSchema(childSchema);
        Optional<Type> clazzType = this.getTypes().findType((DocumentedNode.WithStatus)origSchema);
        Preconditions.checkArgument((boolean)clazzType.isPresent(), (String)"Failed to find binding type for %s (original %s)", (Object)childSchema, (Object)origSchema);
        try {
            return this.loadClass(clazzType.get());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public final ImmutableMap<YangInstanceIdentifier.AugmentationIdentifier, Type> getAvailableAugmentationTypes(DataNodeContainer container) {
        if (container instanceof AugmentationTarget) {
            HashMap<YangInstanceIdentifier.AugmentationIdentifier, Type> identifierToType = new HashMap<YangInstanceIdentifier.AugmentationIdentifier, Type>();
            BindingRuntimeTypes types = this.getTypes();
            Iterator iterator = ((AugmentationTarget)container).getAvailableAugmentations().iterator();
            while (iterator.hasNext()) {
                Optional<Type> augType;
                AugmentationSchemaNode augment;
                AugmentationSchemaNode augOrig = augment = (AugmentationSchemaNode)iterator.next();
                while (augOrig.getOriginalDefinition().isPresent()) {
                    augOrig = (AugmentationSchemaNode)augOrig.getOriginalDefinition().get();
                }
                if (augment.getChildNodes().isEmpty() || !(augType = types.findType((DocumentedNode.WithStatus)augOrig)).isPresent()) continue;
                identifierToType.put(AbstractBindingRuntimeContext.getAugmentationIdentifier(augment), augType.get());
            }
            return ImmutableMap.copyOf(identifierToType);
        }
        return ImmutableMap.of();
    }

    @Override
    public final Class<?> getIdentityClass(QName input) {
        return (Class)this.identityClasses.getUnchecked((Object)input);
    }

    private static YangInstanceIdentifier.AugmentationIdentifier getAugmentationIdentifier(AugmentationSchemaNode augment) {
        return YangInstanceIdentifier.AugmentationIdentifier.create((ImmutableSet)((ImmutableSet)augment.getChildNodes().stream().map(SchemaNode::getQName).collect(ImmutableSet.toImmutableSet())));
    }

    private static Set<Type> collectAllContainerTypes(GeneratedType type, Set<Type> collection) {
        for (MethodSignature definition : type.getMethodDefinitions()) {
            Type childType = definition.getReturnType();
            if (childType instanceof ParameterizedType) {
                childType = ((ParameterizedType)childType).getActualTypeArguments()[0];
            }
            if (!(childType instanceof GeneratedType) && !(childType instanceof GeneratedTypeBuilder)) continue;
            collection.add(childType);
        }
        for (Type parent : type.getImplements()) {
            if (!(parent instanceof GeneratedType)) continue;
            AbstractBindingRuntimeContext.collectAllContainerTypes((GeneratedType)parent, collection);
        }
        return collection;
    }

    private static <T extends SchemaNode> T getOriginalSchema(T choice) {
        SchemaNode original = SchemaNodeUtils.getRootOriginalIfPossible(choice);
        if (original != null) {
            return (T)original;
        }
        return choice;
    }

    private static @NonNull Optional<CaseSchemaNode> findInstantiatedCase(ChoiceSchemaNode instantiatedChoice, CaseSchemaNode originalDefinition) {
        SchemaNode potentialRoot;
        CaseSchemaNode potential = instantiatedChoice.findCase(originalDefinition.getQName()).orElse(null);
        if (originalDefinition.equals(potential)) {
            return Optional.of(potential);
        }
        if (potential != null && originalDefinition.equals(potentialRoot = SchemaNodeUtils.getRootOriginalIfPossible((SchemaNode)potential))) {
            return Optional.of(potential);
        }
        for (CaseSchemaNode caze : instantiatedChoice.findCaseNodes(originalDefinition.getQName().getLocalName())) {
            if (!originalDefinition.equals(SchemaNodeUtils.getRootOriginalIfPossible((SchemaNode)caze))) continue;
            return Optional.of(caze);
        }
        return Optional.empty();
    }
}

