/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.runtime.api;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.model.api.Type;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContextProvider;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public final class BindingRuntimeTypes
implements EffectiveModelContextProvider,
Immutable {
    private static final Logger LOG = LoggerFactory.getLogger(BindingRuntimeTypes.class);
    private static final VarHandle TYPE_TO_IDENTIFIER;
    private final @NonNull EffectiveModelContext schemaContext;
    private final ImmutableMap<Type, AugmentationSchemaNode> typeToAugmentation;
    private final ImmutableMap<Type, DocumentedNode.WithStatus> typeToSchema;
    private final ImmutableMultimap<Type, Type> choiceToCases;
    private final ImmutableMap<QName, Type> identities;
    private final Map<DocumentedNode.WithStatus, Type> schemaToType;
    private volatile ImmutableMap<Type, SchemaNodeIdentifier.Absolute> typeToIdentifier = ImmutableMap.of();

    public BindingRuntimeTypes(EffectiveModelContext schemaContext, Map<Type, AugmentationSchemaNode> typeToAugmentation, Map<Type, DocumentedNode.WithStatus> typeToSchema, Map<DocumentedNode.WithStatus, Type> schemaToType, Multimap<Type, Type> choiceToCases, Map<QName, Type> identities) {
        Object copy;
        this.schemaContext = Objects.requireNonNull(schemaContext);
        this.typeToAugmentation = ImmutableMap.copyOf(typeToAugmentation);
        this.typeToSchema = ImmutableMap.copyOf(typeToSchema);
        this.choiceToCases = ImmutableMultimap.copyOf(choiceToCases);
        this.identities = ImmutableMap.copyOf(identities);
        try {
            copy = ImmutableMap.copyOf(schemaToType);
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Equality-duplicates found in {}", schemaToType.keySet());
            copy = new IdentityHashMap<DocumentedNode.WithStatus, Type>(schemaToType);
        }
        this.schemaToType = copy;
    }

    public BindingRuntimeTypes(EffectiveModelContext schemaContext, Map<Type, AugmentationSchemaNode> typeToAugmentation, BiMap<Type, DocumentedNode.WithStatus> typeToDefiningSchema, Multimap<Type, Type> choiceToCases, Map<QName, Type> identities) {
        this(schemaContext, typeToAugmentation, (Map<Type, DocumentedNode.WithStatus>)typeToDefiningSchema, (Map<DocumentedNode.WithStatus, Type>)typeToDefiningSchema.inverse(), choiceToCases, identities);
    }

    public EffectiveModelContext getEffectiveModelContext() {
        return this.schemaContext;
    }

    public Optional<AugmentationSchemaNode> findAugmentation(Type type) {
        return Optional.ofNullable((AugmentationSchemaNode)this.typeToAugmentation.get((Object)type));
    }

    public Optional<Type> findIdentity(QName qname) {
        return Optional.ofNullable((Type)this.identities.get((Object)qname));
    }

    public Optional<DocumentedNode.WithStatus> findSchema(Type type) {
        return Optional.ofNullable((DocumentedNode.WithStatus)this.typeToSchema.get((Object)type));
    }

    public Optional<SchemaNodeIdentifier.Absolute> findSchemaNodeIdentifier(Type type) {
        ImmutableMap local = TYPE_TO_IDENTIFIER.getAcquire(this);
        SchemaNodeIdentifier.Absolute existing = (SchemaNodeIdentifier.Absolute)local.get((Object)type);
        return existing != null ? Optional.of(existing) : this.loadSchemaNodeIdentifier((ImmutableMap<Type, SchemaNodeIdentifier.Absolute>)local, type);
    }

    public Optional<Type> findType(DocumentedNode.WithStatus schema) {
        return Optional.ofNullable(this.schemaToType.get(schema));
    }

    public Multimap<Type, Type> getChoiceToCases() {
        return this.choiceToCases;
    }

    public Collection<Type> findCases(Type choiceType) {
        return this.choiceToCases.get((Object)choiceType);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("typeToAugmentation", this.typeToAugmentation).add("typeToSchema", this.typeToSchema).add("choiceToCases", this.choiceToCases).add("identities", this.identities).toString();
    }

    private Optional<SchemaNodeIdentifier.Absolute> loadSchemaNodeIdentifier(ImmutableMap<Type, SchemaNodeIdentifier.Absolute> local, Type type) {
        Object witness;
        SchemaNodeIdentifier.Absolute raced;
        DocumentedNode.WithStatus schema = (DocumentedNode.WithStatus)this.typeToSchema.get((Object)type);
        if (!(schema instanceof SchemaNode)) {
            return Optional.empty();
        }
        SchemaNodeIdentifier.Absolute created = SchemaNodeIdentifier.Absolute.of((Collection)ImmutableList.copyOf((Collection)((SchemaNode)schema).getPath().getPathFromRoot())).intern();
        ImmutableMap prev = local;
        do {
            ImmutableMap next;
            if ((witness = TYPE_TO_IDENTIFIER.compareAndExchangeRelease(this, prev, next = ImmutableMap.builderWithExpectedSize((int)(prev.size() + 1)).putAll(prev).put((Object)type, (Object)created).build())) != prev) continue;
            return Optional.of(created);
        } while ((raced = (SchemaNodeIdentifier.Absolute)(prev = (ImmutableMap)witness).get((Object)type)) == null);
        return Optional.of(raced);
    }

    static {
        try {
            TYPE_TO_IDENTIFIER = MethodHandles.lookup().findVarHandle(BindingRuntimeTypes.class, "typeToIdentifier", ImmutableMap.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

