/*
 * Decompiled with CFR 0.152.
 */
package tech.pantheon.triemap;

final class Constants {
    static final int HASH_BITS = 32;
    static final int BITMAP_BITS = 32;
    static final int LEVEL_BITS = 5;
    static final int MAX_DEPTH = 7;

    private Constants() {
    }

    static {
        int expectedBits = (int)(Math.log(32.0) / Math.log(2.0));
        if (5 != expectedBits) {
            throw new AssertionError((Object)String.format("BITMAP_BITS=%s implies LEVEL_BITS=%s, but %s found", 32, expectedBits, 5));
        }
        int expectedDepth = (int)Math.ceil(6.4);
        if (7 != expectedDepth) {
            throw new AssertionError((Object)String.format("HASH_BITS=%s and LEVEL_BITS=%s implies MAX_DEPTH=%s, but %s found", 32, 5, expectedDepth, 7));
        }
    }
}

