/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.xpath.api;

import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.xpath.api.DoubleXPathMathSupport;
import org.opendaylight.yangtools.yang.xpath.api.YangNumberExpr;

final class DoubleNumberExpr
extends YangNumberExpr {
    private static final long serialVersionUID = 1L;
    private final double value;

    private DoubleNumberExpr(double value) {
        this.value = value;
    }

    static DoubleNumberExpr of(double value) {
        return new DoubleNumberExpr(value);
    }

    double getValue() {
        return this.value;
    }

    @Override
    public Double getNumber() {
        return this.value;
    }

    @Override
    public DoubleXPathMathSupport getSupport() {
        return DoubleXPathMathSupport.INSTANCE;
    }

    @Override
    public int hashCode() {
        return Double.hashCode(this.value);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof DoubleNumberExpr && this.bitEqual(((DoubleNumberExpr)obj).value);
    }

    private boolean bitEqual(double other) {
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(other);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

