/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeCodecContext;
import org.opendaylight.yangtools.yang.binding.BindingObject;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;

abstract class AbstractBindingNormalizedNodeCache<T extends BindingObject, C extends NodeCodecContext>
extends CacheLoader<T, NormalizedNode<?, ?>> {
    private final LoadingCache<T, NormalizedNode<?, ?>> cache = CacheBuilder.newBuilder().weakValues().build((CacheLoader)this);
    private final @NonNull C rootContext;

    AbstractBindingNormalizedNodeCache(C rootContext) {
        this.rootContext = (NodeCodecContext)Objects.requireNonNull(rootContext);
    }

    final @NonNull C rootContext() {
        return this.rootContext;
    }

    final NormalizedNode<?, ?> get(@NonNull T obj) {
        return (NormalizedNode)this.cache.getUnchecked(obj);
    }
}

