/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.time.Instant;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingInstanceIdentifierCodec;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingNormalizedNodeWriterFactory;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingStreamEventWriter;
import org.opendaylight.mdsal.binding.dom.codec.impl.ActionCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.CaseNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ChoiceNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataObjectSerializer;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataObjectSerializerRegistry;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataObjectStreamer;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataObjectStreamerGenerator;
import org.opendaylight.mdsal.binding.dom.codec.impl.IdentifiableItemCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.IdentityCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.InstanceIdentifierCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.LeafNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.LeafSetNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ListNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NotificationCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.OpaqueNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.RpcInputCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.SchemaRootCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.UnionTypeCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.ValueContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ValueNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ValueTypeCodec;
import org.opendaylight.mdsal.binding.dom.codec.loader.CodecClassLoader;
import org.opendaylight.mdsal.binding.dom.codec.spi.AbstractBindingNormalizedNodeSerializer;
import org.opendaylight.mdsal.binding.dom.codec.spi.BindingDOMCodecServices;
import org.opendaylight.mdsal.binding.dom.codec.spi.BindingSchemaMapping;
import org.opendaylight.mdsal.binding.runtime.api.BindingRuntimeContext;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.concepts.Delegator;
import org.opendaylight.yangtools.concepts.IllegalArgumentCodec;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.util.ClassLoaderUtils;
import org.opendaylight.yangtools.yang.binding.Action;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.binding.OpaqueObject;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.binding.RpcOutput;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.ChoiceNode;
import org.opendaylight.yangtools.yang.data.api.schema.ContainerNode;
import org.opendaylight.yangtools.yang.data.api.schema.LeafSetNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.data.api.schema.ValueNode;
import org.opendaylight.yangtools.yang.data.api.schema.stream.NormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNormalizedNodeStreamWriter;
import org.opendaylight.yangtools.yang.data.impl.schema.NormalizedNodeResult;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Beta
public final class BindingCodecContext
extends AbstractBindingNormalizedNodeSerializer
implements BindingDOMCodecServices,
Immutable,
NodeCodecContext.CodecContextFactory,
DataObjectSerializerRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(BindingCodecContext.class);
    private final LoadingCache<Class<?>, DataObjectStreamer<?>> streamers = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, DataObjectStreamer<?>>(){

        public DataObjectStreamer<?> load(Class<?> key) throws ReflectiveOperationException {
            Class<DataObjectStreamer<?>> streamer = DataObjectStreamerGenerator.generateStreamer(BindingCodecContext.this.loader, BindingCodecContext.this, key);
            Field instance = streamer.getDeclaredField("INSTANCE");
            return (DataObjectStreamer)instance.get(null);
        }
    });
    private final LoadingCache<Class<?>, DataObjectSerializer> serializers = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, DataObjectSerializer>(){

        public DataObjectSerializer load(Class<?> key) throws ExecutionException {
            return new DataObjectSerializerProxy((DataObjectStreamer)BindingCodecContext.this.streamers.get(key));
        }
    });
    private final @NonNull CodecClassLoader loader = CodecClassLoader.create();
    private final @NonNull InstanceIdentifierCodec instanceIdentifierCodec;
    private final @NonNull IdentityCodec identityCodec;
    private final @NonNull BindingRuntimeContext context;
    private final SchemaRootCodecContext<?> root;

    public BindingCodecContext() {
        this(ServiceLoader.load(BindingRuntimeContext.class).findFirst().orElseThrow(() -> new IllegalStateException("Failed to load BindingRuntimeContext")));
    }

    @Inject
    public BindingCodecContext(BindingRuntimeContext context) {
        this.context = Objects.requireNonNull(context, "Binding Runtime Context is required.");
        this.root = SchemaRootCodecContext.create(this);
        this.identityCodec = new IdentityCodec(context);
        this.instanceIdentifierCodec = new InstanceIdentifierCodec(this);
    }

    @Override
    public BindingRuntimeContext getRuntimeContext() {
        return this.context;
    }

    @Override
    public CodecClassLoader getLoader() {
        return this.loader;
    }

    public IdentityCodec getIdentityCodec() {
        return this.identityCodec;
    }

    public BindingInstanceIdentifierCodec getInstanceIdentifierCodec() {
        return this.instanceIdentifierCodec;
    }

    @Override
    public DataObjectSerializer getEventStreamSerializer(Class<?> type) {
        return (DataObjectSerializer)this.serializers.getUnchecked(type);
    }

    @Override
    public DataObjectStreamer<?> getDataObjectSerializer(Class<?> type) {
        return (DataObjectStreamer)this.streamers.getUnchecked(type);
    }

    @Override
    public DataObjectSerializer getSerializer(Class<? extends DataObject> type) {
        return (DataObjectSerializer)this.serializers.getUnchecked(type);
    }

    public Map.Entry<YangInstanceIdentifier, BindingStreamEventWriter> newWriterAndIdentifier(InstanceIdentifier<?> path, NormalizedNodeStreamWriter domWriter) {
        LinkedList<YangInstanceIdentifier.PathArgument> yangArgs = new LinkedList<YangInstanceIdentifier.PathArgument>();
        DataContainerCodecContext<?, ?> codecContext = this.getCodecContextNode(path, yangArgs);
        return new AbstractMap.SimpleEntry<YangInstanceIdentifier, BindingStreamEventWriter>(YangInstanceIdentifier.create(yangArgs), codecContext.createWriter(domWriter));
    }

    public BindingStreamEventWriter newWriter(InstanceIdentifier<?> path, NormalizedNodeStreamWriter domWriter) {
        return this.getCodecContextNode(path, null).createWriter(domWriter);
    }

    public BindingStreamEventWriter newRpcWriter(Class<? extends DataContainer> rpcInputOrOutput, NormalizedNodeStreamWriter domWriter) {
        return this.root.getRpc(rpcInputOrOutput).createWriter(domWriter);
    }

    public BindingStreamEventWriter newNotificationWriter(Class<? extends Notification> notification, NormalizedNodeStreamWriter domWriter) {
        return this.root.getNotification(notification).createWriter(domWriter);
    }

    public BindingStreamEventWriter newActionInputWriter(Class<? extends Action<?, ?, ?>> action, NormalizedNodeStreamWriter domWriter) {
        return this.getActionCodec(action).input().createWriter(domWriter);
    }

    public BindingStreamEventWriter newActionOutputWriter(Class<? extends Action<?, ?, ?>> action, NormalizedNodeStreamWriter domWriter) {
        return this.getActionCodec(action).output().createWriter(domWriter);
    }

    DataContainerCodecContext<?, ?> getCodecContextNode(InstanceIdentifier<?> binding, List<YangInstanceIdentifier.PathArgument> builder) {
        BindingDataObjectCodecTreeNode currentNode = this.root;
        for (InstanceIdentifier.PathArgument bindingArg : binding.getPathArguments()) {
            Preconditions.checkArgument(((currentNode = currentNode.bindingPathArgumentChild(bindingArg, (List)builder)) != null ? 1 : 0) != 0, (String)"Supplied Instance Identifier %s is not valid.", binding);
        }
        return currentNode;
    }

    @Nullable BindingDataObjectCodecTreeNode<?> getCodecContextNode(@NonNull YangInstanceIdentifier dom, @Nullable Collection<// Could not load outer class - annotation placement on inner may be incorrect
    InstanceIdentifier.PathArgument> bindingArguments) {
        NodeCodecContext currentNode = this.root;
        DataContainerCodecContext currentList = null;
        for (YangInstanceIdentifier.PathArgument domArg : dom.getPathArguments()) {
            Preconditions.checkArgument((boolean)(currentNode instanceof DataContainerCodecContext), (String)"Unexpected child of non-container node %s", currentNode);
            DataContainerCodecContext previous = currentNode;
            NodeCodecContext nextNode = previous.yangPathArgumentChild(domArg);
            if (currentList != null) {
                Preconditions.checkArgument((currentList == nextNode ? 1 : 0) != 0, (String)"List should be referenced two times in YANG Instance Identifier %s", (Object)dom);
                if (bindingArguments != null) {
                    bindingArguments.add(currentList.getBindingPathArgument(domArg));
                }
                currentList = null;
                currentNode = nextNode;
                continue;
            }
            if (nextNode instanceof ListNodeCodecContext) {
                currentList = (ListNodeCodecContext)nextNode;
                continue;
            }
            if (nextNode instanceof ChoiceNodeCodecContext) {
                currentNode = nextNode;
                continue;
            }
            if (nextNode instanceof DataContainerCodecContext) {
                if (bindingArguments != null) {
                    bindingArguments.add(((DataContainerCodecContext)nextNode).getBindingPathArgument(domArg));
                }
                currentNode = nextNode;
                continue;
            }
            if (!(nextNode instanceof ValueNodeCodecContext)) continue;
            LOG.debug("Instance identifier referencing a leaf is not representable ({})", (Object)dom);
            return null;
        }
        if (currentNode instanceof ChoiceNodeCodecContext) {
            LOG.debug("Instance identifier targeting a choice is not representable ({})", (Object)dom);
            return null;
        }
        if (currentNode instanceof CaseNodeCodecContext) {
            LOG.debug("Instance identifier targeting a case is not representable ({})", (Object)dom);
            return null;
        }
        if (currentList != null) {
            if (bindingArguments != null) {
                bindingArguments.add(currentList.getBindingPathArgument(null));
            }
            return currentList;
        }
        if (currentNode != null) {
            Verify.verify((boolean)(currentNode instanceof BindingDataObjectCodecTreeNode), (String)"Illegal return node %s for identifier %s", currentNode, (Object)dom);
            return currentNode;
        }
        return null;
    }

    NotificationCodecContext<?> getNotificationContext(SchemaNodeIdentifier.Absolute notification) {
        return this.root.getNotification(notification);
    }

    RpcInputCodec<?> getRpcInputCodec(SchemaNodeIdentifier.Absolute containerPath) {
        return this.root.getRpc(containerPath);
    }

    ActionCodecContext getActionCodec(Class<? extends Action<?, ?, ?>> action) {
        return this.root.getAction(action);
    }

    @Override
    public ImmutableMap<Method, ValueNodeCodecContext> getLeafNodes(Class<?> parentClass, DataNodeContainer childSchema) {
        HashMap<String, DataSchemaNode> getterToLeafSchema = new HashMap<String, DataSchemaNode>();
        for (DataSchemaNode leaf : childSchema.getChildNodes()) {
            if (!(leaf instanceof TypedDataSchemaNode) && !(leaf instanceof AnyxmlSchemaNode) && !(leaf instanceof AnydataSchemaNode)) continue;
            getterToLeafSchema.put(BindingSchemaMapping.getGetterMethodName((DataSchemaNode)leaf), leaf);
        }
        return this.getLeafNodesUsingReflection(parentClass, getterToLeafSchema);
    }

    private ImmutableMap<Method, ValueNodeCodecContext> getLeafNodesUsingReflection(Class<?> parentClass, Map<String, DataSchemaNode> getterToLeafSchema) {
        HashMap<Method, OpaqueNodeCodecContext.Anyxml<? extends OpaqueObject>> leaves = new HashMap<Method, OpaqueNodeCodecContext.Anyxml<? extends OpaqueObject>>();
        for (Method method : parentClass.getMethods()) {
            ValueNodeCodecContext valueNode;
            Class<Object> valueType;
            if (method.getParameterCount() != 0 || method.isBridge()) continue;
            DataSchemaNode schema = getterToLeafSchema.get(method.getName());
            if (schema instanceof LeafSchemaNode) {
                LeafSchemaNode leafSchema = (LeafSchemaNode)schema;
                valueType = method.getReturnType();
                IllegalArgumentCodec<Object, Object> codec = this.getCodec(valueType, leafSchema.getType());
                valueNode = LeafNodeCodecContext.of(leafSchema, codec, method.getName(), valueType, this.context.getEffectiveModelContext());
            } else if (schema instanceof LeafListSchemaNode) {
                Optional optType = ClassLoaderUtils.getFirstGenericParameter((Type)method.getGenericReturnType());
                Preconditions.checkState((boolean)optType.isPresent(), (String)"Failed to find return type for %s", (Object)method);
                Type genericType = (Type)optType.get();
                if (genericType instanceof Class) {
                    valueType = (Class<Object>)((Object)genericType);
                } else if (genericType instanceof ParameterizedType) {
                    valueType = (Class)((ParameterizedType)genericType).getRawType();
                } else if (genericType instanceof WildcardType) {
                    valueType = Object.class;
                } else {
                    throw new IllegalStateException("Unexpected return type " + genericType);
                }
                LeafListSchemaNode leafListSchema = (LeafListSchemaNode)schema;
                IllegalArgumentCodec<Object, Object> codec = this.getCodec(valueType, leafListSchema.getType());
                valueNode = new LeafSetNodeCodecContext(leafListSchema, codec, method.getName());
            } else if (schema instanceof AnyxmlSchemaNode) {
                valueNode = new OpaqueNodeCodecContext.Anyxml<OpaqueObject>((AnyxmlSchemaNode)schema, method.getName(), BindingCodecContext.opaqueReturnType(method), this.loader);
            } else if (schema instanceof AnydataSchemaNode) {
                valueNode = new OpaqueNodeCodecContext.Anydata<OpaqueObject>((AnydataSchemaNode)schema, method.getName(), BindingCodecContext.opaqueReturnType(method), this.loader);
            } else {
                Verify.verify((schema == null ? 1 : 0) != 0, (String)"Unhandled schema %s for method %s", (Object)schema, (Object)method);
                continue;
            }
            leaves.put(method, (OpaqueNodeCodecContext.Anyxml<? extends OpaqueObject>)valueNode);
        }
        return ImmutableMap.copyOf(leaves);
    }

    IllegalArgumentCodec<Object, Object> getCodec(Class<?> valueType, TypeDefinition<?> instantiatedType) {
        if (Class.class.equals(valueType)) {
            IdentityCodec casted = this.identityCodec;
            return casted;
        }
        if (InstanceIdentifier.class.equals(valueType)) {
            InstanceIdentifierCodec casted = this.instanceIdentifierCodec;
            return casted;
        }
        if (BindingReflections.isBindingClass(valueType)) {
            return this.getCodecForBindingClass(valueType, instantiatedType);
        }
        return ValueTypeCodec.NOOP_CODEC;
    }

    private IllegalArgumentCodec<Object, Object> getCodecForBindingClass(Class<?> valueType, TypeDefinition<?> typeDef) {
        if (typeDef instanceof IdentityrefTypeDefinition) {
            return ValueTypeCodec.encapsulatedValueCodecFor(valueType, typeDef, (IllegalArgumentCodec)this.identityCodec);
        }
        if (typeDef instanceof InstanceIdentifierTypeDefinition) {
            return ValueTypeCodec.encapsulatedValueCodecFor(valueType, typeDef, this.instanceIdentifierCodec);
        }
        if (typeDef instanceof UnionTypeDefinition) {
            Callable<UnionTypeCodec> unionLoader = UnionTypeCodec.loader(valueType, (UnionTypeDefinition)typeDef, this);
            try {
                return unionLoader.call();
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to load codec for " + valueType, e);
            }
        }
        if (typeDef instanceof LeafrefTypeDefinition) {
            Map.Entry typeWithSchema = this.context.getTypeWithSchema(valueType);
            DocumentedNode.WithStatus schema = (DocumentedNode.WithStatus)typeWithSchema.getValue();
            Preconditions.checkState((boolean)(schema instanceof TypeDefinition));
            return this.getCodec(valueType, (TypeDefinition)schema);
        }
        return ValueTypeCodec.getCodecFor(valueType, typeDef);
    }

    @Override
    public IdentifiableItemCodec getPathArgumentCodec(Class<?> listClz, ListSchemaNode schema) {
        Optional optIdentifier = ClassLoaderUtils.findFirstGenericArgument(listClz, Identifiable.class);
        Preconditions.checkState((boolean)optIdentifier.isPresent(), (String)"Failed to find identifier for %s", listClz);
        Class identifier = (Class)optIdentifier.get();
        HashMap<QName, ValueContext> valueCtx = new HashMap<QName, ValueContext>();
        for (ValueNodeCodecContext leaf : this.getLeafNodes(identifier, (DataNodeContainer)schema).values()) {
            QName name = leaf.getDomPathArgument().getNodeType();
            valueCtx.put(name, new ValueContext(identifier, leaf));
        }
        return IdentifiableItemCodec.of(schema, identifier, listClz, valueCtx);
    }

    public <T extends DataObject> BindingDataObjectCodecTreeNode<T> getSubtreeCodec(InstanceIdentifier<T> path) {
        return this.getCodecContextNode(path, null);
    }

    public BindingCodecTreeNode getSubtreeCodec(YangInstanceIdentifier path) {
        return this.getCodecContextNode(path, null);
    }

    public BindingCodecTreeNode getSubtreeCodec(SchemaNodeIdentifier.Absolute path) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public YangInstanceIdentifier toYangInstanceIdentifier(InstanceIdentifier<?> binding) {
        return this.instanceIdentifierCodec.fromBinding(binding);
    }

    public <T extends DataObject> InstanceIdentifier<T> fromYangInstanceIdentifier(YangInstanceIdentifier dom) {
        return this.instanceIdentifierCodec.toBinding(dom);
    }

    public <T extends DataObject> Map.Entry<YangInstanceIdentifier, NormalizedNode<?, ?>> toNormalizedNode(InstanceIdentifier<T> path, T data) {
        NormalizedNodeResult result = new NormalizedNodeResult();
        NormalizedNodeStreamWriter domWriter = ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeResult)result);
        Map.Entry<YangInstanceIdentifier, BindingStreamEventWriter> writeCtx = this.newWriterAndIdentifier(path, domWriter);
        try {
            this.getSerializer(path.getTargetType()).serialize(data, writeCtx.getValue());
        }
        catch (IOException e) {
            LOG.error("Unexpected failure while serializing path {} data {}", new Object[]{path, data, e});
            throw new IllegalStateException("Failed to create normalized node", e);
        }
        return new AbstractMap.SimpleEntry(writeCtx.getKey(), result.getResult());
    }

    public Map.Entry<InstanceIdentifier<?>, DataObject> fromNormalizedNode(YangInstanceIdentifier path, NormalizedNode<?, ?> data) {
        if (BindingCodecContext.notBindingRepresentable(data)) {
            return null;
        }
        ArrayList<InstanceIdentifier.PathArgument> builder = new ArrayList<InstanceIdentifier.PathArgument>();
        BindingDataObjectCodecTreeNode<?> codec = this.getCodecContextNode(path, builder);
        if (codec == null) {
            if (data != null) {
                LOG.warn("Path {} does not have a binding equivalent, should have been caught earlier ({})", (Object)path, data.getClass());
            }
            return null;
        }
        DataObject lazyObj = (DataObject)codec.deserialize(data);
        InstanceIdentifier bindingPath = InstanceIdentifier.create(builder);
        return new AbstractMap.SimpleEntry(bindingPath, lazyObj);
    }

    public Notification fromNormalizedNodeNotification(SchemaNodeIdentifier.Absolute path, ContainerNode data) {
        return (Notification)this.getNotificationContext(path).deserialize((NormalizedNode<?, ?>)data);
    }

    public Notification fromNormalizedNodeNotification(SchemaNodeIdentifier.Absolute path, ContainerNode data, Instant eventInstant) {
        return eventInstant == null ? this.fromNormalizedNodeNotification(path, data) : this.getNotificationContext(path).deserialize(data, eventInstant);
    }

    public DataObject fromNormalizedNodeRpcData(SchemaNodeIdentifier.Absolute containerPath, ContainerNode data) {
        return (DataObject)this.getRpcInputCodec(containerPath).deserialize((NormalizedNode)data);
    }

    public <T extends RpcInput> T fromNormalizedNodeActionInput(Class<? extends Action<?, ?, ?>> action, ContainerNode input) {
        return (T)((RpcInput)Objects.requireNonNull((DataObject)this.getActionCodec(action).input().deserialize((NormalizedNode)Objects.requireNonNull(input))));
    }

    public <T extends RpcOutput> T fromNormalizedNodeActionOutput(Class<? extends Action<?, ?, ?>> action, ContainerNode output) {
        return (T)((RpcOutput)Objects.requireNonNull((DataObject)this.getActionCodec(action).output().deserialize((NormalizedNode)Objects.requireNonNull(output))));
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public ContainerNode toNormalizedNodeNotification(@NonNull Notification data) {
        return this.serializeDataObject((DataObject)data, (ctx, iface, domWriter) -> ctx.newNotificationWriter(iface.asSubclass(Notification.class), domWriter));
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public ContainerNode toNormalizedNodeRpcData(DataContainer data) {
        return this.serializeDataObject((DataObject)data, BindingNormalizedNodeWriterFactory::newRpcWriter);
    }

    public ContainerNode toNormalizedNodeActionInput(Class<? extends Action<?, ?, ?>> action, RpcInput input) {
        return this.serializeDataObject((DataObject)input, (ctx, iface, domWriter) -> ctx.newActionInputWriter(action, domWriter));
    }

    public ContainerNode toNormalizedNodeActionOutput(Class<? extends Action<?, ?, ?>> action, RpcOutput output) {
        return this.serializeDataObject((DataObject)output, (ctx, iface, domWriter) -> ctx.newActionOutputWriter(action, domWriter));
    }

    private <T extends DataContainer> @NonNull ContainerNode serializeDataObject(DataObject data, WriterFactoryMethod<T> newWriter) {
        NormalizedNodeResult result = new NormalizedNodeResult();
        NormalizedNodeStreamWriter domWriter = ImmutableNormalizedNodeStreamWriter.from((NormalizedNodeResult)result);
        Class type = data.implementedInterface();
        BindingStreamEventWriter writer = newWriter.createWriter((BindingNormalizedNodeWriterFactory)this, type, domWriter);
        try {
            this.getSerializer(type).serialize(data, writer);
        }
        catch (IOException e) {
            LOG.error("Unexpected failure while serializing data {}", (Object)data, (Object)e);
            throw new IllegalStateException("Failed to create normalized node", e);
        }
        return (ContainerNode)result.getResult();
    }

    private static boolean notBindingRepresentable(NormalizedNode<?, ?> data) {
        return data instanceof ValueNode || data instanceof MapNode || data instanceof UnkeyedListNode || data instanceof ChoiceNode || data instanceof LeafSetNode;
    }

    private static Class<? extends OpaqueObject> opaqueReturnType(Method method) {
        Class<?> valueType = method.getReturnType();
        Verify.verify((boolean)OpaqueObject.class.isAssignableFrom(valueType), (String)"Illegal value type %s", valueType);
        return valueType.asSubclass(OpaqueObject.class);
    }

    @FunctionalInterface
    private static interface WriterFactoryMethod<T extends DataContainer> {
        public BindingStreamEventWriter createWriter(@NonNull BindingNormalizedNodeWriterFactory var1, @NonNull Class<? extends T> var2, @NonNull NormalizedNodeStreamWriter var3);
    }

    private final class DataObjectSerializerProxy
    implements DataObjectSerializer,
    Delegator<DataObjectStreamer<?>> {
        private final @NonNull DataObjectStreamer<?> delegate;

        DataObjectSerializerProxy(DataObjectStreamer<?> delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        public DataObjectStreamer<?> getDelegate() {
            return this.delegate;
        }

        @Override
        public void serialize(DataObject obj, BindingStreamEventWriter stream) throws IOException {
            this.delegate.serialize(BindingCodecContext.this, obj, stream);
        }
    }
}

