/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Verify;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataObjectCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.KeyedListNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeContextSupplier;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;

public abstract class CodecDataObject<T extends DataObject>
implements DataObject {
    private static final @NonNull Object NULL_VALUE = new Object();
    private static final VarHandle CACHED_HASH_CODE;
    private final @NonNull DataObjectCodecContext<T, ?> context;
    private final @NonNull NormalizedNodeContainer data;
    private volatile Integer cachedHashcode;

    protected CodecDataObject(DataObjectCodecContext<T, ?> context, NormalizedNodeContainer<?, ?, ?> data) {
        this.data = Objects.requireNonNull(data, "Data must not be null");
        this.context = Objects.requireNonNull(context, "Context must not be null");
    }

    public final int hashCode() {
        Integer cached = CACHED_HASH_CODE.getAcquire(this);
        return cached != null ? cached.intValue() : this.loadHashCode();
    }

    public final boolean equals(Object obj) {
        return this.codecEquals(obj);
    }

    public abstract String toString();

    protected final Object codecMember(VarHandle handle, String localName) {
        Object cached = handle.getAcquire(this);
        return cached != null ? CodecDataObject.unmaskNull(cached) : this.loadMember(handle, this.context.getLeafChild(localName));
    }

    protected final Object codecMember(VarHandle handle, Class<? extends DataObject> bindingClass) {
        Object cached = handle.getAcquire(this);
        return cached != null ? CodecDataObject.unmaskNull(cached) : this.loadMember(handle, (NodeCodecContext)this.context.streamChild(bindingClass));
    }

    protected final Object codecMember(VarHandle handle, NodeContextSupplier supplier) {
        Object cached = handle.getAcquire(this);
        return cached != null ? CodecDataObject.unmaskNull(cached) : this.loadMember(handle, supplier.get());
    }

    protected final @NonNull Object codecKey(VarHandle handle) {
        Object cached = handle.getAcquire(this);
        return cached != null ? cached : this.loadKey(handle);
    }

    protected abstract int codecHashCode();

    protected abstract boolean codecEquals(Object var1);

    final @NonNull DataObjectCodecContext<T, ?> codecContext() {
        return this.context;
    }

    final @NonNull NormalizedNodeContainer codecData() {
        return this.data;
    }

    private Object loadMember(VarHandle handle, NodeCodecContext childCtx) {
        Optional child = this.data.getChild(childCtx.getDomPathArgument());
        Object obj = child.isPresent() ? childCtx.deserializeObject((NormalizedNode)child.get()) : childCtx.defaultObject();
        Object witness = handle.compareAndExchangeRelease(this, null, CodecDataObject.maskNull(obj));
        return witness == null ? obj : CodecDataObject.unmaskNull(witness);
    }

    private @NonNull Object loadKey(VarHandle handle) {
        Verify.verify((boolean)(this.data instanceof MapEntryNode), (String)"Unsupported value %s", (Object)this.data);
        Verify.verify((boolean)(this.context instanceof KeyedListNodeCodecContext), (String)"Unexpected context %s", this.context);
        Identifier<?> obj = ((KeyedListNodeCodecContext)this.context).deserialize(((MapEntryNode)this.data).getIdentifier());
        Object witness = handle.compareAndExchangeRelease(this, null, obj);
        return witness == null ? obj : witness;
    }

    private int loadHashCode() {
        int result = this.codecHashCode();
        Object witness = CACHED_HASH_CODE.compareAndExchangeRelease(this, null, result);
        return witness == null ? result : (Integer)witness;
    }

    private static @NonNull Object maskNull(@Nullable Object unmasked) {
        return unmasked == null ? NULL_VALUE : unmasked;
    }

    private static @Nullable Object unmaskNull(Object masked) {
        return masked == NULL_VALUE ? null : masked;
    }

    static {
        try {
            CACHED_HASH_CODE = MethodHandles.lookup().findVarHandle(CodecDataObject.class, "cachedHashcode", Integer.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

