/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.collect.Iterables;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.impl.AugmentationNodeContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.CaseNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ChoiceNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ContainerNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.KeyedListNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ListNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeContextSupplier;
import org.opendaylight.yangtools.yang.binding.DataRoot;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DataContainerCodecPrototype<T extends DocumentedNode.WithStatus>
implements NodeContextSupplier {
    private static final Logger LOG = LoggerFactory.getLogger(DataContainerCodecPrototype.class);
    private static final VarHandle INSTANCE;
    private final T schema;
    private final QNameModule namespace;
    private final NodeCodecContext.CodecContextFactory factory;
    private final InstanceIdentifier.Item<?> bindingArg;
    private final YangInstanceIdentifier.PathArgument yangArg;
    private final BindingDataObjectCodecTreeNode.ChildAddressabilitySummary childAddressabilitySummary;
    private volatile DataContainerCodecContext<?, T> instance;

    private DataContainerCodecPrototype(Class<?> cls, YangInstanceIdentifier.PathArgument arg, T nodeSchema, NodeCodecContext.CodecContextFactory factory) {
        this(InstanceIdentifier.Item.of(cls), arg, nodeSchema, factory);
    }

    private DataContainerCodecPrototype(InstanceIdentifier.Item<?> bindingArg, YangInstanceIdentifier.PathArgument arg, T nodeSchema, NodeCodecContext.CodecContextFactory factory) {
        this.bindingArg = bindingArg;
        this.yangArg = arg;
        this.schema = nodeSchema;
        this.factory = factory;
        this.namespace = arg instanceof YangInstanceIdentifier.AugmentationIdentifier ? ((QName)Iterables.getFirst((Iterable)((YangInstanceIdentifier.AugmentationIdentifier)arg).getPossibleChildNames(), null)).getModule() : arg.getNodeType().getModule();
        this.childAddressabilitySummary = DataContainerCodecPrototype.computeChildAddressabilitySummary(nodeSchema);
    }

    private static BindingDataObjectCodecTreeNode.ChildAddressabilitySummary computeChildAddressabilitySummary(DocumentedNode.WithStatus nodeSchema) {
        if (nodeSchema instanceof DataNodeContainer) {
            boolean haveAddressable = false;
            boolean haveUnaddressable = false;
            block10: for (DataSchemaNode child : ((DataNodeContainer)nodeSchema).getChildNodes()) {
                if (child instanceof ContainerSchemaNode || child instanceof AugmentationSchemaNode) {
                    haveAddressable = true;
                    continue;
                }
                if (child instanceof ListSchemaNode) {
                    if (((ListSchemaNode)child).getKeyDefinition().isEmpty()) {
                        haveUnaddressable = true;
                        continue;
                    }
                    haveAddressable = true;
                    continue;
                }
                if (child instanceof AnydataSchemaNode || child instanceof AnyxmlSchemaNode || child instanceof TypedDataSchemaNode) {
                    haveUnaddressable = true;
                    continue;
                }
                if (child instanceof ChoiceSchemaNode) {
                    switch (DataContainerCodecPrototype.computeChildAddressabilitySummary((DocumentedNode.WithStatus)child)) {
                        case ADDRESSABLE: {
                            haveAddressable = true;
                            continue block10;
                        }
                        case MIXED: {
                            haveAddressable = true;
                            haveUnaddressable = true;
                            continue block10;
                        }
                        case UNADDRESSABLE: {
                            haveUnaddressable = true;
                            continue block10;
                        }
                    }
                    throw new IllegalStateException("Unhandled accessibility summary for " + child);
                }
                LOG.warn("Unhandled child node {}", (Object)child);
            }
            if (!haveAddressable) {
                return BindingDataObjectCodecTreeNode.ChildAddressabilitySummary.UNADDRESSABLE;
            }
            return haveUnaddressable ? BindingDataObjectCodecTreeNode.ChildAddressabilitySummary.MIXED : BindingDataObjectCodecTreeNode.ChildAddressabilitySummary.ADDRESSABLE;
        }
        if (nodeSchema instanceof ChoiceSchemaNode) {
            boolean haveAddressable = false;
            boolean haveUnaddressable = false;
            block11: for (CaseSchemaNode child : ((ChoiceSchemaNode)nodeSchema).getCases()) {
                switch (DataContainerCodecPrototype.computeChildAddressabilitySummary((DocumentedNode.WithStatus)child)) {
                    case ADDRESSABLE: {
                        haveAddressable = true;
                        continue block11;
                    }
                    case UNADDRESSABLE: {
                        haveUnaddressable = true;
                        continue block11;
                    }
                    case MIXED: {
                        return BindingDataObjectCodecTreeNode.ChildAddressabilitySummary.MIXED;
                    }
                }
                throw new IllegalStateException("Unhandled accessibility summary for " + child);
            }
            if (!haveAddressable) {
                return BindingDataObjectCodecTreeNode.ChildAddressabilitySummary.UNADDRESSABLE;
            }
            return haveUnaddressable ? BindingDataObjectCodecTreeNode.ChildAddressabilitySummary.MIXED : BindingDataObjectCodecTreeNode.ChildAddressabilitySummary.ADDRESSABLE;
        }
        return BindingDataObjectCodecTreeNode.ChildAddressabilitySummary.UNADDRESSABLE;
    }

    static DataContainerCodecPrototype<SchemaContext> rootPrototype(NodeCodecContext.CodecContextFactory factory) {
        EffectiveModelContext schema = factory.getRuntimeContext().getEffectiveModelContext();
        YangInstanceIdentifier.NodeIdentifier arg = YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName());
        return new DataContainerCodecPrototype<EffectiveModelContext>(DataRoot.class, (YangInstanceIdentifier.PathArgument)arg, schema, factory);
    }

    static <T extends DataSchemaNode> DataContainerCodecPrototype<T> from(Class<?> cls, T schema, NodeCodecContext.CodecContextFactory factory) {
        return new DataContainerCodecPrototype<T>(cls, (YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName()), schema, factory);
    }

    static <T extends DataSchemaNode> DataContainerCodecPrototype<T> from(InstanceIdentifier.Item<?> bindingArg, T schema, NodeCodecContext.CodecContextFactory factory) {
        return new DataContainerCodecPrototype<T>(bindingArg, (YangInstanceIdentifier.PathArgument)YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName()), schema, factory);
    }

    static DataContainerCodecPrototype<AugmentationSchemaNode> from(Class<?> augClass, YangInstanceIdentifier.AugmentationIdentifier arg, AugmentationSchemaNode schema, NodeCodecContext.CodecContextFactory factory) {
        return new DataContainerCodecPrototype<AugmentationSchemaNode>(augClass, (YangInstanceIdentifier.PathArgument)arg, schema, factory);
    }

    static DataContainerCodecPrototype<NotificationDefinition> from(Class<?> augClass, NotificationDefinition schema, NodeCodecContext.CodecContextFactory factory) {
        YangInstanceIdentifier.NodeIdentifier arg = YangInstanceIdentifier.NodeIdentifier.create((QName)schema.getQName());
        return new DataContainerCodecPrototype<NotificationDefinition>(augClass, (YangInstanceIdentifier.PathArgument)arg, schema, factory);
    }

    T getSchema() {
        return this.schema;
    }

    BindingDataObjectCodecTreeNode.ChildAddressabilitySummary getChildAddressabilitySummary() {
        return this.childAddressabilitySummary;
    }

    QNameModule getNamespace() {
        return this.namespace;
    }

    NodeCodecContext.CodecContextFactory getFactory() {
        return this.factory;
    }

    Class<?> getBindingClass() {
        return this.bindingArg.getType();
    }

    InstanceIdentifier.Item<?> getBindingArg() {
        return this.bindingArg;
    }

    YangInstanceIdentifier.PathArgument getYangArg() {
        return this.yangArg;
    }

    @Override
    public DataContainerCodecContext<?, T> get() {
        DataContainerCodecContext<?, T> existing = INSTANCE.getAcquire(this);
        return existing != null ? existing : this.loadInstance();
    }

    private @NonNull DataContainerCodecContext<?, T> loadInstance() {
        DataContainerCodecContext tmp = this.createInstance();
        Object witness = INSTANCE.compareAndExchangeRelease(this, null, tmp);
        return witness == null ? tmp : (DataContainerCodecContext)witness;
    }

    private @NonNull DataContainerCodecContext<?, T> createInstance() {
        if (this.schema instanceof ContainerLike) {
            return new ContainerNodeCodecContext(this);
        }
        if (this.schema instanceof ListSchemaNode) {
            return Identifiable.class.isAssignableFrom(this.getBindingClass()) ? KeyedListNodeCodecContext.create(this) : new ListNodeCodecContext(this);
        }
        if (this.schema instanceof ChoiceSchemaNode) {
            return new ChoiceNodeCodecContext(this);
        }
        if (this.schema instanceof AugmentationSchemaNode) {
            return new AugmentationNodeContext(this);
        }
        if (this.schema instanceof CaseSchemaNode) {
            return new CaseNodeCodecContext(this);
        }
        throw new IllegalArgumentException("Unsupported type " + this.getBindingClass() + " " + this.schema);
    }

    boolean isChoice() {
        return this.schema instanceof ChoiceSchemaNode;
    }

    static {
        try {
            INSTANCE = MethodHandles.lookup().findVarHandle(DataContainerCodecPrototype.class, "instance", DataContainerCodecContext.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

