/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Throwables;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.opendaylight.mdsal.binding.dom.codec.impl.ReflectionBasedCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.ValueTypeCodec;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;

final class EncapsulatedValueCodec
extends ReflectionBasedCodec
implements ValueTypeCodec.SchemaUnawareCodec {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.publicLookup();
    private static final MethodType OBJ_METHOD = MethodType.methodType(Object.class, Object.class);
    private final MethodHandle constructor;
    private final MethodHandle getter;
    private final Class<?> valueType;

    private EncapsulatedValueCodec(Class<?> typeClz, MethodHandle constructor, MethodHandle getter, Class<?> valueType) {
        super(typeClz);
        this.constructor = Objects.requireNonNull(constructor);
        this.getter = Objects.requireNonNull(getter);
        this.valueType = Objects.requireNonNull(valueType);
    }

    static Callable<EncapsulatedValueCodec> loader(Class<?> typeClz, TypeDefinition<?> typeDef) {
        return () -> {
            Method m = typeClz.getMethod("getValue", new Class[0]);
            MethodHandle getter = LOOKUP.unreflect(m).asType(OBJ_METHOD);
            Class<?> valueType = m.getReturnType();
            MethodHandle constructor = LOOKUP.findConstructor(typeClz, MethodType.methodType(Void.TYPE, valueType)).asType(OBJ_METHOD);
            return new EncapsulatedValueCodec(typeClz, constructor, getter, valueType);
        };
    }

    boolean canAcceptObject(Object value) {
        return this.valueType.isInstance(value);
    }

    public Object deserialize(Object input) {
        try {
            return this.constructor.invokeExact(input);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public Object serialize(Object input) {
        try {
            return this.getter.invokeExact(input);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException(e);
        }
    }
}

