/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.opendaylight.mdsal.binding.dom.codec.impl.ReflectionBasedCodec;
import org.opendaylight.mdsal.binding.dom.codec.impl.ValueTypeCodec;
import org.opendaylight.yangtools.yang.binding.Enumeration;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class EnumerationCodec
extends ReflectionBasedCodec
implements ValueTypeCodec.SchemaUnawareCodec {
    private static final Logger LOG = LoggerFactory.getLogger(EnumerationCodec.class);
    private final ImmutableBiMap<String, Enum<?>> nameToEnum;

    EnumerationCodec(Class<? extends Enum<?>> enumeration, Map<String, Enum<?>> nameToEnum) {
        super(enumeration);
        this.nameToEnum = ImmutableBiMap.copyOf(nameToEnum);
    }

    static Callable<EnumerationCodec> loader(Class<?> returnType, EnumTypeDefinition def) {
        Preconditions.checkArgument((boolean)Enum.class.isAssignableFrom(returnType));
        Class<?> enumType = returnType;
        return () -> {
            ImmutableMap mapping = Maps.uniqueIndex(Arrays.asList((Enum[])enumType.getEnumConstants()), value -> {
                Preconditions.checkArgument((boolean)(value instanceof Enumeration), (String)"Enumeration constant %s.%s is not implementing Enumeration", (Object)enumType.getName(), (Object)value);
                return ((Enumeration)value).getName();
            });
            Set assignedNames = def.getValues().stream().map(EnumTypeDefinition.EnumPair::getName).collect(Collectors.toSet());
            for (String name : assignedNames) {
                if (mapping.containsKey(name)) continue;
                LOG.warn("Enumeration {} does not contain assigned name '{}' from {}", new Object[]{enumType, name, def});
            }
            for (String name : mapping.keySet()) {
                if (assignedNames.contains(name)) continue;
                LOG.warn("Enumeration {} contains assigned name '{}' not covered by {}", new Object[]{enumType, name, def});
            }
            return new EnumerationCodec(enumType, (Map<String, Enum<?>>)mapping);
        };
    }

    public Enum<?> deserialize(Object input) {
        Preconditions.checkArgument((boolean)(input instanceof String), (String)"Input %s is not a String", (Object)input);
        Enum value = (Enum)this.nameToEnum.get(input);
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"Invalid enumeration value %s. Valid values are %s", (Object)input, (Object)this.nameToEnum.keySet());
        return value;
    }

    public String serialize(Object input) {
        Preconditions.checkArgument((boolean)this.getTypeClass().isInstance(input), (String)"Input %s is not a instance of %s", (Object)input, this.getTypeClass());
        return Objects.requireNonNull((String)this.nameToEnum.inverse().get(input));
    }
}

