/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.impl.ValueContext;
import org.opendaylight.mdsal.binding.spec.naming.BindingMapping;
import org.opendaylight.yangtools.concepts.AbstractIllegalArgumentCodec;
import org.opendaylight.yangtools.util.ImmutableOffsetMap;
import org.opendaylight.yangtools.util.ImmutableOffsetMapTemplate;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class IdentifiableItemCodec
extends AbstractIllegalArgumentCodec<YangInstanceIdentifier.NodeIdentifierWithPredicates, InstanceIdentifier.IdentifiableItem<?, ?>> {
    private static final Logger LOG = LoggerFactory.getLogger(IdentifiableItemCodec.class);
    private final Class<?> identifiable;
    private final QName qname;

    IdentifiableItemCodec(ListSchemaNode schema, Class<? extends Identifier<?>> keyClass, Class<?> identifiable) {
        this.identifiable = Objects.requireNonNull(identifiable);
        this.qname = schema.getQName();
    }

    static IdentifiableItemCodec of(ListSchemaNode schema, Class<? extends Identifier<?>> keyClass, Class<?> identifiable, Map<QName, ValueContext> keyValueContexts) {
        switch (keyValueContexts.size()) {
            case 0: {
                throw new IllegalArgumentException("Key " + keyClass + " of " + identifiable + " has no components");
            }
            case 1: {
                Map.Entry<QName, ValueContext> entry = keyValueContexts.entrySet().iterator().next();
                return new SingleKey(schema, keyClass, identifiable, entry.getKey(), entry.getValue());
            }
        }
        return new MultiKey(schema, keyClass, identifiable, keyValueContexts);
    }

    protected final InstanceIdentifier.IdentifiableItem<?, ?> deserializeImpl(YangInstanceIdentifier.NodeIdentifierWithPredicates input) {
        Identifier<?> identifier = this.deserializeIdentifier(input);
        return InstanceIdentifier.IdentifiableItem.of(this.identifiable, identifier);
    }

    protected final YangInstanceIdentifier.NodeIdentifierWithPredicates serializeImpl(InstanceIdentifier.IdentifiableItem<?, ?> input) {
        return this.serializeIdentifier(this.qname, input.getKey());
    }

    final @NonNull Identifier<?> deserializeIdentifier(YangInstanceIdentifier.NodeIdentifierWithPredicates input) {
        try {
            return this.deserializeIdentifierImpl(input);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException("Failed to deserialize " + input, e);
        }
    }

    abstract @NonNull Identifier<?> deserializeIdentifierImpl(// Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.NodeIdentifierWithPredicates var1) throws Throwable;

    abstract // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull YangInstanceIdentifier.NodeIdentifierWithPredicates serializeIdentifier(QName var1, Identifier<?> var2);

    static MethodHandle getConstructor(Class<? extends Identifier<?>> clazz, int nrArgs) {
        for (Constructor<?> ctor : clazz.getConstructors()) {
            if (ctor.getParameterCount() != nrArgs) {
                LOG.debug("Skipping {} due to argument count mismatch", ctor);
                continue;
            }
            if (IdentifiableItemCodec.isDeprecated(ctor)) {
                LOG.debug("Skipping deprecated constructor {}", ctor);
                continue;
            }
            if (clazz.equals(ctor.getParameterTypes()[0])) {
                LOG.debug("Skipping copy constructor {}", ctor);
                continue;
            }
            try {
                return MethodHandles.publicLookup().unreflectConstructor(ctor);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Cannot access constructor " + ctor + " in class " + clazz, e);
            }
        }
        throw new IllegalArgumentException("Supplied class " + clazz + " does not have required constructor.");
    }

    private static boolean isDeprecated(Constructor<?> ctor) {
        return ctor.getAnnotation(Deprecated.class) != null;
    }

    private static final class MultiKey
    extends IdentifiableItemCodec {
        private final ImmutableOffsetMapTemplate<QName> predicateTemplate;
        private final ImmutableOffsetMap<QName, ValueContext> keyValueContexts;
        private final ImmutableList<QName> keysInBindingOrder;
        private final MethodHandle ctor;

        MultiKey(ListSchemaNode schema, Class<? extends Identifier<?>> keyClass, Class<?> identifiable, Map<QName, ValueContext> keyValueContexts) {
            super(schema, keyClass, identifiable);
            MethodHandle tmpCtor = MultiKey.getConstructor(keyClass, keyValueContexts.size());
            MethodHandle inv = MethodHandles.spreadInvoker(tmpCtor.type(), 0);
            this.ctor = inv.asType(inv.type().changeReturnType(Identifier.class)).bindTo(tmpCtor);
            ArrayList<QName> keyDef = schema.getKeyDefinition();
            this.predicateTemplate = ImmutableOffsetMapTemplate.ordered((Collection)keyDef);
            this.keyValueContexts = this.predicateTemplate.instantiateTransformed(keyValueContexts, (key, value) -> value);
            ArrayList<QName> tmp = new ArrayList<QName>(keyDef);
            tmp.sort(Comparator.comparing(qname -> BindingMapping.getPropertyName((String)qname.getLocalName())));
            this.keysInBindingOrder = ImmutableList.copyOf(tmp.equals(keyDef) ? keyDef : tmp);
        }

        @Override
        Identifier<?> deserializeIdentifierImpl(YangInstanceIdentifier.NodeIdentifierWithPredicates nip) throws Throwable {
            Object[] bindingValues = new Object[this.keysInBindingOrder.size()];
            int offset = 0;
            for (QName key : this.keysInBindingOrder) {
                bindingValues[offset++] = ((ValueContext)this.keyValueContexts.get((Object)key)).deserialize(nip.getValue(key));
            }
            return this.ctor.invokeExact(bindingValues);
        }

        @Override
        YangInstanceIdentifier.NodeIdentifierWithPredicates serializeIdentifier(QName qname, Identifier<?> key) {
            Object[] values = new Object[this.keyValueContexts.size()];
            int offset = 0;
            for (ValueContext valueCtx : this.keyValueContexts.values()) {
                values[offset++] = valueCtx.getAndSerialize(key);
            }
            return YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)qname, (ImmutableOffsetMap)this.predicateTemplate.instantiateWithValues(values));
        }
    }

    private static final class SingleKey
    extends IdentifiableItemCodec {
        private static final MethodType CTOR_TYPE = MethodType.methodType(Identifier.class, Object.class);
        private final ValueContext keyContext;
        private final MethodHandle ctor;
        private final QName keyName;

        SingleKey(ListSchemaNode schema, Class<? extends Identifier<?>> keyClass, Class<?> identifiable, QName keyName, ValueContext keyContext) {
            super(schema, keyClass, identifiable);
            this.keyContext = Objects.requireNonNull(keyContext);
            this.keyName = Objects.requireNonNull(keyName);
            this.ctor = SingleKey.getConstructor(keyClass, 1).asType(CTOR_TYPE);
        }

        @Override
        Identifier<?> deserializeIdentifierImpl(YangInstanceIdentifier.NodeIdentifierWithPredicates nip) throws Throwable {
            return this.ctor.invokeExact(this.keyContext.deserialize(nip.getValue(this.keyName)));
        }

        @Override
        YangInstanceIdentifier.NodeIdentifierWithPredicates serializeIdentifier(QName qname, Identifier<?> key) {
            return YangInstanceIdentifier.NodeIdentifierWithPredicates.of((QName)qname, (QName)this.keyName, (Object)this.keyContext.getAndSerialize(key));
        }
    }
}

