/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingTypeObjectCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.impl.ValueNodeCodecContext;
import org.opendaylight.yangtools.concepts.IllegalArgumentCodec;
import org.opendaylight.yangtools.yang.binding.TypeObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.codec.TypeDefinitionAwareCodec;
import org.opendaylight.yangtools.yang.data.impl.schema.ImmutableNodes;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.EffectiveModelContext;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;

class LeafNodeCodecContext
extends ValueNodeCodecContext.WithCodec {
    LeafNodeCodecContext(LeafSchemaNode schema, IllegalArgumentCodec<Object, Object> codec, String getterName, EffectiveModelContext schemaContext) {
        super((DataSchemaNode)schema, codec, getterName, LeafNodeCodecContext.createDefaultObject(schema, codec, schemaContext));
    }

    static LeafNodeCodecContext of(LeafSchemaNode schema, IllegalArgumentCodec<Object, Object> codec, String getterName, Class<?> valueType, EffectiveModelContext schemaContext) {
        return TypeObject.class.isAssignableFrom(valueType) ? new OfTypeObject<TypeObject>(schema, codec, getterName, schemaContext, valueType.asSubclass(TypeObject.class)) : new LeafNodeCodecContext(schema, codec, getterName, schemaContext);
    }

    @Override
    protected Object deserializeObject(NormalizedNode<?, ?> normalizedNode) {
        return normalizedNode != null ? this.getValueCodec().deserialize(normalizedNode.getValue()) : null;
    }

    private static Object createDefaultObject(LeafSchemaNode schema, IllegalArgumentCodec<Object, Object> codec, EffectiveModelContext schemaContext) {
        Optional defaultValue = schema.getType().getDefaultValue();
        TypeDefinition type = schema.getType();
        if (defaultValue.isPresent()) {
            if (type instanceof IdentityrefTypeDefinition) {
                return LeafNodeCodecContext.qnameDomValueFromString(codec, (DataSchemaNode)schema, (String)defaultValue.get(), schemaContext);
            }
            return LeafNodeCodecContext.domValueFromString(codec, type, defaultValue.get());
        }
        while (type.getBaseType() != null && !type.getDefaultValue().isPresent()) {
            type = type.getBaseType();
        }
        defaultValue = type.getDefaultValue();
        if (defaultValue.isPresent()) {
            if (type instanceof IdentityrefTypeDefinition) {
                return LeafNodeCodecContext.qnameDomValueFromString(codec, (DataSchemaNode)schema, (String)defaultValue.get(), schemaContext);
            }
            return LeafNodeCodecContext.domValueFromString(codec, type, defaultValue);
        }
        return null;
    }

    private static Object qnameDomValueFromString(IllegalArgumentCodec<Object, Object> codec, DataSchemaNode schema, String defaultValue, EffectiveModelContext schemaContext) {
        int prefixEndIndex = defaultValue.indexOf(58);
        if (prefixEndIndex != -1) {
            String defaultValuePrefix = defaultValue.substring(0, prefixEndIndex);
            Module module = (Module)schemaContext.findModule(schema.getQName().getModule()).get();
            if (module.getPrefix().equals(defaultValuePrefix)) {
                QName qname = QName.create((QNameModule)module.getQNameModule(), (String)defaultValue.substring(prefixEndIndex + 1));
                return codec.deserialize((Object)qname);
            }
            for (ModuleImport moduleImport : module.getImports()) {
                if (!moduleImport.getPrefix().equals(defaultValuePrefix)) continue;
                Module importedModule = (Module)schemaContext.findModule(moduleImport.getModuleName(), moduleImport.getRevision()).get();
                QName qname = QName.create((QNameModule)importedModule.getQNameModule(), (String)defaultValue.substring(prefixEndIndex + 1));
                return codec.deserialize((Object)qname);
            }
            return null;
        }
        QName qname = QName.create((QName)schema.getQName(), (String)defaultValue);
        return codec.deserialize((Object)qname);
    }

    private static Object domValueFromString(IllegalArgumentCodec<Object, Object> codec, TypeDefinition<?> type, Object defaultValue) {
        TypeDefinitionAwareCodec typeDefAwareCodec = TypeDefinitionAwareCodec.from(type);
        if (typeDefAwareCodec != null) {
            Object castedDefaultValue = typeDefAwareCodec.deserialize((Object)((String)defaultValue));
            return codec.deserialize(castedDefaultValue);
        }
        return null;
    }

    static final class OfTypeObject<T extends TypeObject>
    extends LeafNodeCodecContext
    implements BindingTypeObjectCodecTreeNode<T> {
        private final @NonNull Class<T> bindingClass;

        OfTypeObject(LeafSchemaNode schema, IllegalArgumentCodec<Object, Object> codec, String getterName, EffectiveModelContext schemaContext, Class<T> bindingClass) {
            super(schema, codec, getterName, schemaContext);
            this.bindingClass = Objects.requireNonNull(bindingClass);
        }

        public Class<T> getBindingClass() {
            return this.bindingClass;
        }

        public T deserialize(NormalizedNode<?, ?> data) {
            return (T)((TypeObject)this.bindingClass.cast(this.deserializeObject(data)));
        }

        public NormalizedNode<?, ?> serialize(T data) {
            return ImmutableNodes.leafNode((YangInstanceIdentifier.NodeIdentifier)this.getDomPathArgument(), (Object)this.getValueCodec().serialize(data));
        }
    }
}

