/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecPrototype;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataObjectCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.LazyBindingList;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.data.api.schema.MapEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.MapNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNodeContainer;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListEntryNode;
import org.opendaylight.yangtools.yang.data.api.schema.UnkeyedListNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

class ListNodeCodecContext<D extends DataObject>
extends DataObjectCodecContext<D, ListSchemaNode> {
    ListNodeCodecContext(DataContainerCodecPrototype<ListSchemaNode> prototype) {
        super(prototype);
    }

    ListNodeCodecContext(DataContainerCodecPrototype<ListSchemaNode> prototype, Method keyMethod) {
        super(prototype, keyMethod);
    }

    public D deserialize(NormalizedNode<?, ?> node) {
        if (node instanceof MapEntryNode) {
            return this.createBindingProxy((NormalizedNodeContainer<?, ?, ?>)((MapEntryNode)node));
        }
        if (node instanceof UnkeyedListEntryNode) {
            return this.createBindingProxy((NormalizedNodeContainer<?, ?, ?>)((UnkeyedListEntryNode)node));
        }
        throw new IllegalStateException("Unsupported data type " + node.getClass());
    }

    @Override
    protected Object deserializeObject(NormalizedNode<?, ?> node) {
        if (node instanceof MapNode) {
            return this.fromMap((MapNode)node);
        }
        if (node instanceof MapEntryNode) {
            return this.createBindingProxy((NormalizedNodeContainer<?, ?, ?>)((MapEntryNode)node));
        }
        if (node instanceof UnkeyedListNode) {
            return this.fromUnkeyedList((UnkeyedListNode)node);
        }
        if (node instanceof UnkeyedListEntryNode) {
            return this.createBindingProxy((NormalizedNodeContainer<?, ?, ?>)((UnkeyedListEntryNode)node));
        }
        throw new IllegalStateException("Unsupported data type " + node.getClass());
    }

    @NonNull Object fromMap(MapNode map, int size) {
        return LazyBindingList.create(this, size, map.getValue());
    }

    private Object fromMap(MapNode map) {
        int size = map.size();
        return size == 0 ? null : this.fromMap(map, size);
    }

    private List<D> fromUnkeyedList(UnkeyedListNode node) {
        int size = node.getSize();
        return size == 0 ? null : LazyBindingList.create(this, size, (Collection)node.getValue());
    }
}

