/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.util.Objects;
import javax.xml.transform.dom.DOMSource;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingOpaqueObjectCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.impl.CodecOpaqueObject;
import org.opendaylight.mdsal.binding.dom.codec.impl.ForeignOpaqueData;
import org.opendaylight.mdsal.binding.dom.codec.impl.ValueNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.ByteBuddy;
import org.opendaylight.mdsal.binding.dom.codec.jar.bytebuddy.dynamic.DynamicType;
import org.opendaylight.mdsal.binding.dom.codec.loader.CodecClassLoader;
import org.opendaylight.yangtools.concepts.AbstractIllegalArgumentCodec;
import org.opendaylight.yangtools.concepts.IllegalArgumentCodec;
import org.opendaylight.yangtools.yang.binding.OpaqueData;
import org.opendaylight.yangtools.yang.binding.OpaqueObject;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.AnydataNode;
import org.opendaylight.yangtools.yang.data.api.schema.DOMSourceAnyxmlNode;
import org.opendaylight.yangtools.yang.data.api.schema.ForeignDataNode;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.data.impl.schema.Builders;
import org.opendaylight.yangtools.yang.model.api.AnydataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.AnyxmlSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;

abstract class OpaqueNodeCodecContext<T extends OpaqueObject<T>>
extends ValueNodeCodecContext
implements BindingOpaqueObjectCodecTreeNode<T> {
    private static final MethodType CONSTRUCTOR_TYPE = MethodType.methodType(OpaqueObject.class, OpaqueData.class);
    private static final DynamicType.Builder<CodecOpaqueObject> TEMPLATE = new ByteBuddy().subclass(CodecOpaqueObject.class).modifiers(4113);
    private final IllegalArgumentCodec<Object, Object> valueCodec = new AbstractIllegalArgumentCodec<Object, Object>(){

        protected Object serializeImpl(Object input) {
            Preconditions.checkArgument((boolean)OpaqueNodeCodecContext.this.bindingClass.isInstance(input), (String)"Unexpected input %s", (Object)input);
            OpaqueData opaqueData = (OpaqueData)((OpaqueObject)OpaqueNodeCodecContext.this.bindingClass.cast(input)).getValue();
            Object data = opaqueData.getData();
            Preconditions.checkArgument((boolean)(data instanceof DOMSource), (String)"Unexpected data %s", (Object)data);
            return data;
        }

        protected Object deserializeImpl(Object input) {
            Preconditions.checkArgument((boolean)(input instanceof NormalizedNode), (String)"Unexpected input %s", (Object)input);
            return OpaqueNodeCodecContext.this.deserializeObject((NormalizedNode)input);
        }
    };
    private final MethodHandle proxyConstructor;
    private final @NonNull Class<T> bindingClass;

    OpaqueNodeCodecContext(DataSchemaNode schema, String getterName, Class<T> bindingClass, CodecClassLoader loader) {
        super(schema, getterName, null);
        this.bindingClass = Objects.requireNonNull(bindingClass);
        this.proxyConstructor = OpaqueNodeCodecContext.createImpl(loader, bindingClass);
    }

    public final Class<T> getBindingClass() {
        return this.bindingClass;
    }

    public final T deserialize(NormalizedNode<?, ?> data) {
        Preconditions.checkArgument((boolean)(data instanceof ForeignDataNode), (String)"Unexpected value %s", data);
        return this.deserialize((ForeignDataNode)data);
    }

    T deserialize(ForeignDataNode<?, ?> foreignData) {
        return (T)((OpaqueObject)this.bindingClass.cast(this.createBindingProxy((OpaqueData<?>)new ForeignOpaqueData(foreignData))));
    }

    public final ForeignDataNode<?, ?> serialize(T data) {
        OpaqueData opaqueData = (OpaqueData)data.getValue();
        return opaqueData instanceof ForeignOpaqueData ? ((ForeignOpaqueData)opaqueData).domData() : this.serializedData(opaqueData);
    }

    @Override
    protected final @NonNull Object deserializeObject(NormalizedNode<?, ?> normalizedNode) {
        return this.deserialize(normalizedNode);
    }

    @Override
    IllegalArgumentCodec<Object, Object> getValueCodec() {
        return this.valueCodec;
    }

    abstract @NonNull ForeignDataNode<?, ?> serializedData(OpaqueData<?> var1);

    private OpaqueObject<?> createBindingProxy(OpaqueData<?> data) {
        try {
            return this.proxyConstructor.invokeExact(data);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private static MethodHandle createImpl(CodecClassLoader rootLoader, Class<?> bindingClass) {
        Constructor ctor;
        Class proxyClass = rootLoader.generateClass(bindingClass, "codecImpl", (loader, fqcn, bindingInterface) -> CodecClassLoader.GeneratorResult.of(TEMPLATE.name(fqcn).implement(bindingInterface).make()));
        try {
            ctor = proxyClass.getDeclaredConstructor(OpaqueData.class);
        }
        catch (NoSuchMethodException e) {
            throw new LinkageError("Failed to acquire constructor for prototype " + proxyClass, e);
        }
        try {
            return MethodHandles.publicLookup().unreflectConstructor(ctor).asType(CONSTRUCTOR_TYPE);
        }
        catch (IllegalAccessException e) {
            throw new LinkageError("Failed to access constructor for prototype " + proxyClass, e);
        }
    }

    static final class Anydata<T extends OpaqueObject<T>>
    extends OpaqueNodeCodecContext<T> {
        Anydata(AnydataSchemaNode schema, String getterName, Class<T> bindingClass, CodecClassLoader loader) {
            super((DataSchemaNode)schema, getterName, bindingClass, loader);
        }

        AnydataNode<?> serializedData(OpaqueData<?> opaqueData) {
            return this.buildAnydata(opaqueData);
        }

        private <M> @NonNull AnydataNode<M> buildAnydata(OpaqueData<M> opaqueData) {
            return (AnydataNode)Builders.anydataBuilder((Class)opaqueData.getObjectModel()).withNodeIdentifier((YangInstanceIdentifier.PathArgument)this.getDomPathArgument()).withValue(opaqueData.getData()).build();
        }
    }

    static final class Anyxml<T extends OpaqueObject<T>>
    extends OpaqueNodeCodecContext<T> {
        Anyxml(AnyxmlSchemaNode schema, String getterName, Class<T> bindingClass, CodecClassLoader loader) {
            super((DataSchemaNode)schema, getterName, bindingClass, loader);
        }

        @Override
        ForeignDataNode<?, ?> serializedData(OpaqueData<?> opaqueData) {
            Class model = opaqueData.getObjectModel();
            Verify.verify((boolean)DOMSource.class.isAssignableFrom(model), (String)"Cannot just yet support object model %s", (Object)model);
            return (ForeignDataNode)Builders.anyXmlBuilder().withNodeIdentifier((YangInstanceIdentifier.PathArgument)this.getDomPathArgument()).withValue((Object)((DOMSource)opaqueData.getData())).build();
        }

        @Override
        T deserialize(ForeignDataNode<?, ?> foreignData) {
            Verify.verify((boolean)(foreignData instanceof DOMSourceAnyxmlNode), (String)"Variable node %s not supported yet", foreignData);
            return super.deserialize(foreignData);
        }
    }
}

