/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.codec.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.impl.ActionCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ChoiceNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.ContainerNodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.DataContainerCodecPrototype;
import org.opendaylight.mdsal.binding.dom.codec.impl.NodeCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.NotificationCodecContext;
import org.opendaylight.mdsal.binding.dom.codec.impl.RpcInputCodec;
import org.opendaylight.mdsal.binding.spec.naming.BindingMapping;
import org.opendaylight.mdsal.binding.spec.reflect.BindingReflections;
import org.opendaylight.yangtools.util.ClassLoaderUtils;
import org.opendaylight.yangtools.yang.binding.Action;
import org.opendaylight.yangtools.yang.binding.ChoiceIn;
import org.opendaylight.yangtools.yang.binding.DataContainer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.KeyedListAction;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.binding.RpcInput;
import org.opendaylight.yangtools.yang.binding.RpcOutput;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.schema.NormalizedNode;
import org.opendaylight.yangtools.yang.model.api.ActionDefinition;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerLike;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.InputSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.OutputSchemaNode;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;
import org.opendaylight.yangtools.yang.model.util.SchemaContextUtil;
import org.opendaylight.yangtools.yang.model.util.SchemaNodeUtils;

final class SchemaRootCodecContext<D extends DataObject>
extends DataContainerCodecContext<D, SchemaContext> {
    private final LoadingCache<Class<? extends DataObject>, DataContainerCodecContext<?, ?>> childrenByClass = CacheBuilder.newBuilder().build(new CacheLoader<Class<? extends DataObject>, DataContainerCodecContext<?, ?>>(){

        public DataContainerCodecContext<?, ?> load(Class<? extends DataObject> key) {
            if (Notification.class.isAssignableFrom(key)) {
                return SchemaRootCodecContext.this.createNotificationDataContext(key);
            }
            if (RpcInput.class.isAssignableFrom(key) || RpcOutput.class.isAssignableFrom(key)) {
                return SchemaRootCodecContext.this.createRpcDataContext(key);
            }
            return SchemaRootCodecContext.this.createDataTreeChildContext(key);
        }
    });
    private final LoadingCache<Class<? extends Action<?, ?, ?>>, ActionCodecContext> actionsByClass = CacheBuilder.newBuilder().build(new CacheLoader<Class<? extends Action<?, ?, ?>>, ActionCodecContext>(){

        public ActionCodecContext load(Class<? extends Action<?, ?, ?>> key) {
            return SchemaRootCodecContext.this.createActionContext(key);
        }
    });
    private final LoadingCache<Class<? extends DataObject>, ChoiceNodeCodecContext<?>> choicesByClass = CacheBuilder.newBuilder().build(new CacheLoader<Class<? extends DataObject>, ChoiceNodeCodecContext<?>>(){

        public ChoiceNodeCodecContext<?> load(Class<? extends DataObject> key) {
            return SchemaRootCodecContext.this.createChoiceDataContext(key);
        }
    });
    private final LoadingCache<QName, DataContainerCodecContext<?, ?>> childrenByQName = CacheBuilder.newBuilder().build(new CacheLoader<QName, DataContainerCodecContext<?, ?>>(){

        public DataContainerCodecContext<?, ?> load(QName qname) {
            DataSchemaNode childSchema = ((SchemaContext)SchemaRootCodecContext.this.getSchema()).dataChildByName(qname);
            SchemaRootCodecContext.this.childNonNull(childSchema, qname, "Argument %s is not valid child of %s", qname, SchemaRootCodecContext.this.getSchema());
            if (childSchema instanceof DataNodeContainer || childSchema instanceof ChoiceSchemaNode) {
                Class childCls = SchemaRootCodecContext.this.factory().getRuntimeContext().getClassForSchema((SchemaNode)childSchema);
                return SchemaRootCodecContext.this.streamChild(childCls);
            }
            throw new UnsupportedOperationException("Unsupported child type " + childSchema.getClass());
        }
    });
    private final LoadingCache<SchemaNodeIdentifier.Absolute, RpcInputCodec<?>> rpcDataByPath = CacheBuilder.newBuilder().build(new CacheLoader<SchemaNodeIdentifier.Absolute, RpcInputCodec<?>>(){

        public RpcInputCodec<?> load(SchemaNodeIdentifier.Absolute key) {
            ContainerLike schema = SchemaContextUtil.getRpcDataSchema((SchemaContext)((SchemaContext)SchemaRootCodecContext.this.getSchema()), (SchemaPath)key.asSchemaPath());
            Class cls = SchemaRootCodecContext.this.factory().getRuntimeContext().getClassForSchema((SchemaNode)schema);
            return SchemaRootCodecContext.this.getRpc(cls);
        }
    });
    private final LoadingCache<SchemaNodeIdentifier.Absolute, NotificationCodecContext<?>> notificationsByPath = CacheBuilder.newBuilder().build(new CacheLoader<SchemaNodeIdentifier.Absolute, NotificationCodecContext<?>>(){

        public NotificationCodecContext<?> load(SchemaNodeIdentifier.Absolute key) {
            NotificationDefinition schema = SchemaContextUtil.getNotificationSchema((SchemaContext)((SchemaContext)SchemaRootCodecContext.this.getSchema()), (SchemaPath)key.asSchemaPath());
            Class clz = SchemaRootCodecContext.this.factory().getRuntimeContext().getClassForSchema((SchemaNode)schema);
            return SchemaRootCodecContext.this.getNotification(clz);
        }
    });

    private SchemaRootCodecContext(DataContainerCodecPrototype<SchemaContext> dataPrototype) {
        super(dataPrototype);
    }

    static SchemaRootCodecContext<?> create(NodeCodecContext.CodecContextFactory factory) {
        DataContainerCodecPrototype<SchemaContext> prototype = DataContainerCodecPrototype.rootPrototype(factory);
        return new SchemaRootCodecContext(prototype);
    }

    @Override
    public <C extends DataObject> DataContainerCodecContext<C, ?> streamChild(Class<C> childClass) {
        return SchemaRootCodecContext.getOrRethrow(this.childrenByClass, childClass);
    }

    @Override
    public <C extends DataObject> Optional<DataContainerCodecContext<C, ?>> possibleStreamChild(Class<C> childClass) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public DataContainerCodecContext<?, ?> yangPathArgumentChild(YangInstanceIdentifier.PathArgument arg) {
        return SchemaRootCodecContext.getOrRethrow(this.childrenByQName, arg.getNodeType());
    }

    public D deserialize(NormalizedNode<?, ?> normalizedNode) {
        throw new UnsupportedOperationException("Could not create Binding data representation for root");
    }

    ActionCodecContext getAction(Class<? extends Action<?, ?, ?>> action) {
        return SchemaRootCodecContext.getOrRethrow(this.actionsByClass, action);
    }

    NotificationCodecContext<?> getNotification(Class<? extends Notification> notification) {
        return (NotificationCodecContext)this.streamChild(notification);
    }

    NotificationCodecContext<?> getNotification(SchemaNodeIdentifier.Absolute notification) {
        return SchemaRootCodecContext.getOrRethrow(this.notificationsByPath, notification);
    }

    ContainerNodeCodecContext<?> getRpc(Class<? extends DataContainer> rpcInputOrOutput) {
        return (ContainerNodeCodecContext)this.streamChild(rpcInputOrOutput);
    }

    RpcInputCodec<?> getRpc(SchemaNodeIdentifier.Absolute containerPath) {
        return SchemaRootCodecContext.getOrRethrow(this.rpcDataByPath, containerPath);
    }

    DataContainerCodecContext<?, ?> createDataTreeChildContext(Class<?> key) {
        QName qname = BindingReflections.findQName(key);
        DataSchemaNode childSchema = this.childNonNull(((SchemaContext)this.getSchema()).dataChildByName(qname), key, "%s is not top-level item.", key);
        return DataContainerCodecPrototype.from(key, childSchema, this.factory()).get();
    }

    ActionCodecContext createActionContext(Class<? extends Action<?, ?, ?>> action) {
        if (KeyedListAction.class.isAssignableFrom(action)) {
            return this.prepareActionContext(2, 3, 4, action, KeyedListAction.class);
        }
        if (Action.class.isAssignableFrom(action)) {
            return this.prepareActionContext(1, 2, 3, action, Action.class);
        }
        throw new IllegalArgumentException("The specific action type does not exist for action " + action.getName());
    }

    private ActionCodecContext prepareActionContext(int inputOffset, int outputOffset, int expectedArgsLength, Class<? extends Action<?, ?, ?>> action, Class<?> actionType) {
        Optional optParamType = ClassLoaderUtils.findParameterizedType(action, actionType);
        Preconditions.checkState((boolean)optParamType.isPresent(), (String)"%s does not specialize %s", action, actionType);
        ParameterizedType paramType = (ParameterizedType)optParamType.get();
        Type[] args = paramType.getActualTypeArguments();
        Preconditions.checkArgument((args.length == expectedArgsLength ? 1 : 0) != 0, (String)"Unexpected (%s) Action generatic arguments", (int)args.length);
        ActionDefinition schema = this.factory().getRuntimeContext().getActionDefinition(action);
        return new ActionCodecContext((DataContainerCodecContext<?, InputSchemaNode>)DataContainerCodecPrototype.from(SchemaRootCodecContext.asClass(args[inputOffset], RpcInput.class), schema.getInput(), this.factory()).get(), (DataContainerCodecContext<?, OutputSchemaNode>)DataContainerCodecPrototype.from(SchemaRootCodecContext.asClass(args[outputOffset], RpcOutput.class), schema.getOutput(), this.factory()).get());
    }

    private static <T extends DataObject> Class<? extends T> asClass(Type type, Class<T> target) {
        Verify.verify((boolean)(type instanceof Class), (String)"Type %s is not a class", (Object)type);
        return ((Class)type).asSubclass(target);
    }

    ContainerNodeCodecContext<?> createRpcDataContext(Class<?> key) {
        Preconditions.checkArgument((boolean)DataContainer.class.isAssignableFrom(key));
        QName qname = BindingReflections.findQName(key);
        QNameModule qnameModule = qname.getModule();
        Module module = (Module)((SchemaContext)this.getSchema()).findModule(qnameModule).orElseThrow(() -> new IllegalArgumentException("Failed to find module for " + qnameModule));
        String className = BindingMapping.getClassName((QName)qname);
        for (RpcDefinition potential : module.getRpcs()) {
            QName potentialQName = potential.getQName();
            if (!key.getSimpleName().equals(BindingMapping.getClassName((QName)potentialQName) + className)) continue;
            ContainerLike schema = SchemaNodeUtils.getRpcDataSchema((RpcDefinition)potential, (QName)qname);
            Preconditions.checkArgument((schema != null ? 1 : 0) != 0, (String)"Schema for %s does not define input / output.", (Object)potential.getQName());
            return (ContainerNodeCodecContext)DataContainerCodecPrototype.from(key, schema, this.factory()).get();
        }
        throw new IllegalArgumentException("Supplied class " + key + " is not valid RPC class.");
    }

    NotificationCodecContext<?> createNotificationDataContext(Class<?> notificationType) {
        Preconditions.checkArgument((boolean)Notification.class.isAssignableFrom(notificationType));
        Preconditions.checkArgument((boolean)notificationType.isInterface(), (Object)"Supplied class must be interface.");
        QName qname = BindingReflections.findQName(notificationType);
        NotificationDefinition schema = (NotificationDefinition)((SchemaContext)this.getSchema()).findNotification(qname).orElseThrow(() -> new IllegalArgumentException("Supplied " + notificationType + " is not valid notification"));
        return new NotificationCodecContext(notificationType, schema, this.factory());
    }

    ChoiceNodeCodecContext<?> createChoiceDataContext(Class<? extends DataObject> caseType) {
        Class<?> choiceClass = SchemaRootCodecContext.findCaseChoice(caseType);
        Preconditions.checkArgument((choiceClass != null ? 1 : 0) != 0, (String)"Class %s is not a valid case representation", caseType);
        DataSchemaNode schema = this.factory().getRuntimeContext().getSchemaDefinition(choiceClass);
        Preconditions.checkArgument((boolean)(schema instanceof ChoiceSchemaNode), (String)"Class %s does not refer to a choice", caseType);
        NodeCodecContext choice = DataContainerCodecPrototype.from(choiceClass, (ChoiceSchemaNode)schema, this.factory()).get();
        Verify.verify((boolean)(choice instanceof ChoiceNodeCodecContext));
        return (ChoiceNodeCodecContext)choice;
    }

    @Override
    protected Object deserializeObject(NormalizedNode<?, ?> normalizedNode) {
        throw new UnsupportedOperationException("Unable to deserialize root");
    }

    public InstanceIdentifier.PathArgument deserializePathArgument(YangInstanceIdentifier.PathArgument arg) {
        Preconditions.checkArgument((arg == null ? 1 : 0) != 0);
        return null;
    }

    public YangInstanceIdentifier.PathArgument serializePathArgument(InstanceIdentifier.PathArgument arg) {
        Preconditions.checkArgument((arg == null ? 1 : 0) != 0);
        return null;
    }

    @Override
    public DataContainerCodecContext<?, ?> bindingPathArgumentChild(InstanceIdentifier.PathArgument arg, List<YangInstanceIdentifier.PathArgument> builder) {
        Optional caseType = arg.getCaseType();
        if (caseType.isPresent()) {
            @NonNull Class type = (Class)caseType.orElseThrow();
            ChoiceNodeCodecContext choice = (ChoiceNodeCodecContext)this.choicesByClass.getUnchecked((Object)type);
            choice.addYangPathArgument(arg, builder);
            BindingDataObjectCodecTreeNode caze = choice.streamChild(type);
            caze.addYangPathArgument(arg, builder);
            return caze.bindingPathArgumentChild(arg, (List)builder);
        }
        return super.bindingPathArgumentChild(arg, (List)builder);
    }

    private static Class<?> findCaseChoice(Class<? extends DataObject> caseClass) {
        for (Type type : caseClass.getGenericInterfaces()) {
            Class typeClass;
            if (!(type instanceof Class) || !ChoiceIn.class.isAssignableFrom(typeClass = (Class)type)) continue;
            return typeClass.asSubclass(ChoiceIn.class);
        }
        return null;
    }

    private static <K, V> V getOrRethrow(LoadingCache<K, V> cache, K key) {
        try {
            return (V)cache.getUnchecked(key);
        }
        catch (UncheckedExecutionException e) {
            Throwable cause = e.getCause();
            if (cause != null) {
                Throwables.throwIfUnchecked((Throwable)cause);
            }
            throw e;
        }
    }
}

