/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.openconfig.stmt;

import com.google.common.collect.ImmutableList;
import org.opendaylight.yangtools.concepts.SemVer;
import org.opendaylight.yangtools.openconfig.model.api.OpenConfigStatements;
import org.opendaylight.yangtools.openconfig.model.api.OpenConfigVersionEffectiveStatement;
import org.opendaylight.yangtools.openconfig.model.api.OpenConfigVersionStatement;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.meta.StatementDefinition;
import org.opendaylight.yangtools.yang.parser.openconfig.stmt.OpenConfigVersionEffectiveStatementImpl;
import org.opendaylight.yangtools.yang.parser.openconfig.stmt.OpenConfigVersionStatementImpl;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.BaseStatementSupport;
import org.opendaylight.yangtools.yang.parser.spi.meta.SemanticVersionNamespace;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.SubstatementValidator;

public final class OpenConfigVersionSupport
extends BaseStatementSupport<SemVer, OpenConfigVersionStatement, OpenConfigVersionEffectiveStatement> {
    private static final SubstatementValidator SUBSTATEMENT_VALIDATOR = SubstatementValidator.builder((StatementDefinition)OpenConfigStatements.OPENCONFIG_VERSION).build();
    private static final OpenConfigVersionSupport INSTANCE = new OpenConfigVersionSupport();

    private OpenConfigVersionSupport() {
        super((StatementDefinition)OpenConfigStatements.OPENCONFIG_VERSION);
    }

    public static OpenConfigVersionSupport getInstance() {
        return INSTANCE;
    }

    public SemVer parseArgumentValue(StmtContext<?, ?, ?> ctx, String value) {
        return SemVer.valueOf((String)value);
    }

    public void onLinkageDeclared(StmtContext.Mutable<SemVer, OpenConfigVersionStatement, OpenConfigVersionEffectiveStatement> stmt) {
        stmt.addToNs(SemanticVersionNamespace.class, (Object)stmt.getParentContext(), (Object)((SemVer)stmt.getStatementArgument()));
    }

    protected SubstatementValidator getSubstatementValidator() {
        return SUBSTATEMENT_VALIDATOR;
    }

    @Override
    protected OpenConfigVersionStatement createDeclared(StmtContext<SemVer, OpenConfigVersionStatement, ?> ctx, ImmutableList<? extends DeclaredStatement<?>> substatements) {
        return new OpenConfigVersionStatementImpl((SemVer)ctx.coerceStatementArgument(), substatements);
    }

    @Override
    protected OpenConfigVersionStatement createEmptyDeclared(StmtContext<SemVer, OpenConfigVersionStatement, ?> ctx) {
        return this.createDeclared(ctx, (ImmutableList<? extends DeclaredStatement<?>>)ImmutableList.of());
    }

    @Override
    protected OpenConfigVersionEffectiveStatement createEffective(StmtContext<SemVer, OpenConfigVersionStatement, OpenConfigVersionEffectiveStatement> ctx, OpenConfigVersionStatement declared, ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        return new OpenConfigVersionEffectiveStatementImpl(declared, substatements, ctx);
    }

    @Override
    protected OpenConfigVersionEffectiveStatement createEmptyEffective(StmtContext<SemVer, OpenConfigVersionStatement, OpenConfigVersionEffectiveStatement> ctx, OpenConfigVersionStatement declared) {
        return this.createEffective(ctx, declared, ImmutableList.of());
    }
}

