/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.annotations.Beta;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.DocumentedNode;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.StatusEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractDeclaredEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStatementMixins;

@Beta
public abstract class AbstractEffectiveDocumentedNodeWithStatus<A, D extends DeclaredStatement<A>>
extends AbstractDeclaredEffectiveStatement<A, D>
implements EffectiveStatementMixins.DocumentedNodeMixin<A, D>,
DocumentedNode.WithStatus {
    private final @NonNull ImmutableList<? extends EffectiveStatement<?, ?>> substatements;
    private final @NonNull D declared;
    private final A argument;

    protected AbstractEffectiveDocumentedNodeWithStatus(A argument, @NonNull D declared, @NonNull ImmutableList<? extends EffectiveStatement<?, ?>> substatements) {
        this.argument = argument;
        this.declared = (DeclaredStatement)Objects.requireNonNull(declared);
        this.substatements = Objects.requireNonNull(substatements);
    }

    public final A argument() {
        return this.argument;
    }

    @Override
    public final @NonNull D getDeclared() {
        return this.declared;
    }

    @Override
    public final Collection<? extends EffectiveStatement<?, ?>> effectiveSubstatements() {
        return this.substatements;
    }

    public final <T> Collection<T> allSubstatementsOfType(Class<T> type) {
        return (Collection)Collection.class.cast(Collections2.filter(this.effectiveSubstatements(), type::isInstance));
    }

    public final Status getStatus() {
        return this.findFirstEffectiveSubstatementArgument(StatusEffectiveStatement.class).orElse(Status.CURRENT);
    }

    protected final <T> @Nullable T firstSubstatementOfType(Class<T> type) {
        return this.effectiveSubstatements().stream().filter(type::isInstance).findFirst().map(type::cast).orElse(null);
    }

    protected final <R> R firstSubstatementOfType(Class<?> type, Class<R> returnType) {
        return this.effectiveSubstatements().stream().filter(((Predicate<Object>)type::isInstance).and(returnType::isInstance)).findFirst().map(returnType::cast).orElse(null);
    }
}

