/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.parser.rfc7950.stmt;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.concepts.SemVer;
import org.opendaylight.yangtools.openconfig.model.api.OpenConfigVersionEffectiveStatement;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.UnqualifiedQName;
import org.opendaylight.yangtools.yang.common.YangVersion;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Deviation;
import org.opendaylight.yangtools.yang.model.api.ExtensionDefinition;
import org.opendaylight.yangtools.yang.model.api.FeatureDefinition;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.ModuleLike;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.opendaylight.yangtools.yang.model.api.meta.DeclaredStatement;
import org.opendaylight.yangtools.yang.model.api.meta.EffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ContactEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.DataTreeAwareEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ImportEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.ModuleEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.OrganizationEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.PrefixStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.TypedefEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.YangVersionEffectiveStatement;
import org.opendaylight.yangtools.yang.model.api.stmt.compat.NotificationNodeContainerCompat;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.AbstractDeclaredEffectiveStatement;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStatementMixins;
import org.opendaylight.yangtools.yang.parser.rfc7950.stmt.EffectiveStmtUtils;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContext;
import org.opendaylight.yangtools.yang.parser.spi.meta.StmtContextUtils;
import org.opendaylight.yangtools.yang.parser.spi.source.ImportPrefixToModuleCtx;
import org.opendaylight.yangtools.yang.parser.spi.source.SourceException;
import org.opendaylight.yangtools.yang.parser.spi.source.StatementSourceReference;

@Beta
public abstract class AbstractEffectiveModule<D extends DeclaredStatement<UnqualifiedQName>, E extends DataTreeAwareEffectiveStatement<UnqualifiedQName, D>>
extends AbstractDeclaredEffectiveStatement.DefaultWithDataTree.WithSubstatements<UnqualifiedQName, D, E>
implements ModuleLike,
EffectiveStatementMixins.DocumentedNodeMixin<UnqualifiedQName, D>,
NotificationNodeContainerCompat<UnqualifiedQName, D, E> {
    private final String prefix;
    private final ImmutableSet<GroupingDefinition> groupings;
    private final ImmutableSet<UsesNode> uses;
    private final ImmutableSet<TypeDefinition<?>> typeDefinitions;

    protected AbstractEffectiveModule(D declared, StmtContext<UnqualifiedQName, D, ? extends EffectiveStatement<UnqualifiedQName, ?>> ctx, ImmutableList<? extends EffectiveStatement<?, ?>> substatements, String prefix) {
        super(declared, ctx, substatements);
        this.prefix = Objects.requireNonNull(prefix);
        LinkedHashSet<GroupingDefinition> mutableGroupings = new LinkedHashSet<GroupingDefinition>();
        LinkedHashSet<UsesNode> mutableUses = new LinkedHashSet<UsesNode>();
        LinkedHashSet<TypeDefinition> mutableTypeDefinitions = new LinkedHashSet<TypeDefinition>();
        for (EffectiveStatement effectiveStatement : this.effectiveSubstatements()) {
            TypeDefinition type;
            if (effectiveStatement instanceof UsesNode && !mutableUses.add((UsesNode)effectiveStatement)) {
                throw EffectiveStmtUtils.createNameCollisionSourceException(ctx, effectiveStatement);
            }
            if (effectiveStatement instanceof TypedefEffectiveStatement && !mutableTypeDefinitions.add(type = ((TypedefEffectiveStatement)effectiveStatement).getTypeDefinition())) {
                throw EffectiveStmtUtils.createNameCollisionSourceException(ctx, effectiveStatement);
            }
            if (!(effectiveStatement instanceof GroupingDefinition) || mutableGroupings.add((GroupingDefinition)effectiveStatement)) continue;
            throw EffectiveStmtUtils.createNameCollisionSourceException(ctx, effectiveStatement);
        }
        this.groupings = ImmutableSet.copyOf(mutableGroupings);
        this.typeDefinitions = ImmutableSet.copyOf(mutableTypeDefinitions);
        this.uses = ImmutableSet.copyOf(mutableUses);
    }

    public UnqualifiedQName argument() {
        return (UnqualifiedQName)this.getDeclared().argument();
    }

    public String getName() {
        return this.argument().getLocalName();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public YangVersion getYangVersion() {
        return this.findFirstEffectiveSubstatementArgument(YangVersionEffectiveStatement.class).orElse(YangVersion.VERSION_1);
    }

    public Optional<String> getOrganization() {
        return this.findFirstEffectiveSubstatementArgument(OrganizationEffectiveStatement.class);
    }

    public Optional<String> getContact() {
        return this.findFirstEffectiveSubstatementArgument(ContactEffectiveStatement.class);
    }

    public Collection<? extends @NonNull ModuleImport> getImports() {
        return this.filterSubstatements(ModuleImport.class);
    }

    public Collection<? extends @NonNull FeatureDefinition> getFeatures() {
        return this.filterSubstatements(FeatureDefinition.class);
    }

    public Collection<? extends @NonNull NotificationDefinition> getNotifications() {
        return this.filterSubstatements(NotificationDefinition.class);
    }

    public Collection<? extends @NonNull AugmentationSchemaNode> getAugmentations() {
        return this.filterSubstatements(AugmentationSchemaNode.class);
    }

    public Collection<? extends @NonNull RpcDefinition> getRpcs() {
        return this.filterSubstatements(RpcDefinition.class);
    }

    public Collection<? extends @NonNull Deviation> getDeviations() {
        return this.filterSubstatements(Deviation.class);
    }

    public Collection<? extends @NonNull ExtensionDefinition> getExtensionSchemaNodes() {
        return this.filterSubstatements(ExtensionDefinition.class);
    }

    public Collection<? extends @NonNull IdentitySchemaNode> getIdentities() {
        return this.filterSubstatements(IdentitySchemaNode.class);
    }

    public final Collection<? extends TypeDefinition<?>> getTypeDefinitions() {
        return this.typeDefinitions;
    }

    public final Collection<? extends DataSchemaNode> getChildNodes() {
        return this.filterSubstatements(DataSchemaNode.class);
    }

    public final Collection<? extends GroupingDefinition> getGroupings() {
        return this.groupings;
    }

    public final Optional<DataSchemaNode> findDataChildByName(QName name) {
        return this.findDataSchemaNode(name);
    }

    public Collection<? extends UsesNode> getUses() {
        return this.uses;
    }

    public Optional<SemVer> getSemanticVersion() {
        return this.findFirstEffectiveSubstatementArgument(OpenConfigVersionEffectiveStatement.class);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.getName()).add("namespace", (Object)this.getNamespace()).add("revision", this.getRevision().orElse(null)).add("prefix", (Object)this.prefix).add("yangVersion", (Object)this.getYangVersion()).toString();
    }

    protected static final @NonNull String findPrefix(@NonNull StmtContext<?, ?, ?> ctx, String type, String name) {
        return (String)SourceException.throwIfNull((Object)((String)StmtContextUtils.firstAttributeOf((Iterable)ctx.declaredSubstatements(), PrefixStatement.class)), (StatementSourceReference)ctx.getStatementSourceReference(), (String)"Unable to resolve prefix for %s %s.", (Object[])new Object[]{type, name});
    }

    protected final void appendPrefixes(StmtContext<?, ?, ?> ctx, ImmutableMap.Builder<String, ModuleEffectiveStatement> builder) {
        this.streamEffectiveSubstatements(ImportEffectiveStatement.class).map(imp -> (String)imp.findFirstEffectiveSubstatementArgument(PrefixEffectiveStatement.class).get()).forEach(pfx -> {
            StmtContext importedCtx = (StmtContext)Verify.verifyNotNull((Object)((StmtContext)ctx.getFromNamespace(ImportPrefixToModuleCtx.class, pfx)), (String)"Failed to resolve prefix %s", (Object[])new Object[]{pfx});
            builder.put(pfx, (Object)((ModuleEffectiveStatement)importedCtx.buildEffective()));
        });
    }

    private <T> @NonNull Collection<? extends T> filterSubstatements(Class<T> type) {
        return Collections2.filter(this.effectiveSubstatements(), type::isInstance);
    }
}

